/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.FactsHolder;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;

public class OnHeapAggregateProjection
implements IncrementalIndexRowSelector {
    private final AggregateProjectionMetadata.Schema projectionSchema;
    private final List<IncrementalIndex.DimensionDesc> dimensions;
    private final int[] parentDimensionIndex;
    private final AggregatorFactory[] aggregatorFactories;
    private final Map<String, IncrementalIndex.DimensionDesc> dimensionsMap;
    private final Map<String, IncrementalIndex.MetricDesc> aggregatorsMap;
    private final Map<String, ColumnFormat> columnFormats;
    private final FactsHolder factsHolder;
    private final IncrementalIndex.InputRowHolder inputRowHolder = new IncrementalIndex.InputRowHolder();
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final ColumnSelectorFactory virtualSelectorFactory;
    private final Map<String, ColumnSelectorFactory> aggSelectors;
    private final long minTimestamp;
    private final AtomicInteger rowCounter = new AtomicInteger(0);
    private final AtomicInteger numEntries = new AtomicInteger(0);
    @Nullable
    private final ValueMatcher valueMatcher;

    public OnHeapAggregateProjection(AggregateProjectionSpec projectionSpec, Function<String, IncrementalIndex.DimensionDesc> getBaseTableDimensionDesc, Function<String, AggregatorFactory> getBaseTableAggregatorFactory, long minTimestamp) {
        this.projectionSchema = projectionSpec.toMetadataSchema();
        this.minTimestamp = minTimestamp;
        this.dimensions = new ArrayList<IncrementalIndex.DimensionDesc>();
        this.parentDimensionIndex = new int[projectionSpec.getGroupingColumns().size()];
        Arrays.fill(this.parentDimensionIndex, -1);
        this.dimensionsMap = new LinkedHashMap<String, IncrementalIndex.DimensionDesc>();
        this.columnFormats = new LinkedHashMap<String, ColumnFormat>();
        this.initializeAndValidateDimensions(projectionSpec, getBaseTableDimensionDesc);
        IncrementalIndex.IncrementalIndexRowComparator rowComparator = new IncrementalIndex.IncrementalIndexRowComparator(this.projectionSchema.getTimeColumnPosition() < 0 ? this.dimensions.size() : this.projectionSchema.getTimeColumnPosition(), this.dimensions);
        this.factsHolder = new OnheapIncrementalIndex.RollupFactsHolder(rowComparator, this.dimensions, this.projectionSchema.getTimeColumnPosition() == 0);
        this.validateVirtualColumns(projectionSpec, getBaseTableDimensionDesc);
        this.virtualSelectorFactory = new OnheapIncrementalIndex.CachingColumnSelectorFactory(IncrementalIndex.makeColumnSelectorFactory(this.projectionSchema.getVirtualColumns(), this.inputRowHolder, null));
        this.aggSelectors = new LinkedHashMap<String, ColumnSelectorFactory>();
        this.aggregatorsMap = new LinkedHashMap<String, IncrementalIndex.MetricDesc>();
        this.aggregatorFactories = new AggregatorFactory[this.projectionSchema.getAggregators().length];
        this.initializeAndValidateAggregators(projectionSpec, getBaseTableDimensionDesc, getBaseTableAggregatorFactory);
        this.valueMatcher = projectionSpec.getFilter() != null ? this.projectionSchema.getFilter().toFilter().makeMatcher(this.virtualSelectorFactory) : null;
    }

    public void addToFacts(IncrementalIndexRow key, InputRow inputRow, List<String> parseExceptionMessages, AtomicLong totalSizeInBytes) {
        Aggregator[] aggs;
        IncrementalIndexRow subKey;
        int priorIndex;
        long timestamp;
        this.inputRowHolder.set(inputRow);
        if (this.valueMatcher != null && !this.valueMatcher.matches(false)) {
            return;
        }
        Object[] projectionDims = new Object[this.dimensions.size()];
        for (int i = 0; i < projectionDims.length; ++i) {
            int parentDimIndex = this.parentDimensionIndex[i];
            if (parentDimIndex < 0) {
                IncrementalIndex.DimensionDesc desc = this.dimensions.get(i);
                ColumnValueSelector virtualSelector = this.virtualSelectorFactory.makeColumnValueSelector(desc.getName());
                EncodedKeyComponent<?> k = desc.getIndexer().processRowValsToUnsortedEncodedKeyComponent(virtualSelector.getObject(), false);
                projectionDims[i] = k.getComponent();
                totalSizeInBytes.addAndGet(k.getEffectiveSizeBytes());
                continue;
            }
            projectionDims[i] = key.dims[this.parentDimensionIndex[i]];
        }
        if (this.projectionSchema.getTimeColumnName() != null) {
            timestamp = this.projectionSchema.getEffectiveGranularity().bucketStart(DateTimes.utc(key.getTimestamp())).getMillis();
            if (timestamp < this.minTimestamp) {
                throw DruidException.defensive("Cannot add row[%s] to projection[%s] because projection effective timestamp[%s] is below the minTimestamp[%s]", inputRow, this.projectionSchema.getName(), DateTimes.utc(timestamp), DateTimes.utc(this.minTimestamp));
            }
        } else {
            timestamp = this.minTimestamp;
        }
        if (-1 != (priorIndex = this.factsHolder.getPriorIndex(subKey = new IncrementalIndexRow(timestamp, projectionDims, this.dimensions)))) {
            aggs = this.aggregators.get(priorIndex);
            long aggForProjectionSizeDelta = OnheapIncrementalIndex.doAggregate(this.aggregatorFactories, aggs, this.inputRowHolder, parseExceptionMessages, false);
            totalSizeInBytes.addAndGet(aggForProjectionSizeDelta);
        } else {
            aggs = new Aggregator[this.aggregatorFactories.length];
            long aggSizeForProjectionRow = this.factorizeAggs(this.aggregatorFactories, aggs);
            long estimatedSizeOfAggregators = aggSizeForProjectionRow += OnheapIncrementalIndex.doAggregate(this.aggregatorFactories, aggs, this.inputRowHolder, parseExceptionMessages, false);
            long projectionRowSize = key.estimateBytesInMemory() + estimatedSizeOfAggregators + 44L;
            totalSizeInBytes.addAndGet(projectionRowSize);
            this.numEntries.incrementAndGet();
        }
        int rowIndex = this.rowCounter.getAndIncrement();
        this.aggregators.put(rowIndex, aggs);
        this.factsHolder.putIfAbsent(subKey, rowIndex);
    }

    @Override
    public FactsHolder getFacts() {
        return this.factsHolder;
    }

    @Override
    public List<IncrementalIndex.DimensionDesc> getDimensions() {
        return this.dimensions;
    }

    @Override
    public List<String> getMetricNames() {
        return ImmutableList.copyOf(this.aggregatorsMap.keySet());
    }

    @Override
    public IncrementalIndex.DimensionDesc getDimension(String columnName) {
        return this.dimensionsMap.get(columnName);
    }

    @Override
    public IncrementalIndex.MetricDesc getMetric(String columnName) {
        return this.aggregatorsMap.get(columnName);
    }

    @Override
    public List<OrderBy> getOrdering() {
        return this.projectionSchema.getOrderingWithTimeColumnSubstitution();
    }

    @Override
    public int getTimePosition() {
        return this.projectionSchema.getTimeColumnPosition();
    }

    @Override
    public boolean isEmpty() {
        return this.rowCounter.get() == 0;
    }

    @Override
    public int getLastRowIndex() {
        return this.rowCounter.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].getLong();
    }

    @Override
    public double getMetricDoubleValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].getDouble();
    }

    @Override
    @Nullable
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].get();
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].isNull();
    }

    @Override
    public ColumnFormat getColumnFormat(String columnName) {
        return this.columnFormats.get(columnName);
    }

    @Override
    public int numRows() {
        return this.numEntries.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDimensionNames(boolean includeTime) {
        Map<String, IncrementalIndex.DimensionDesc> map = this.dimensionsMap;
        synchronized (map) {
            if (includeTime && this.projectionSchema.getTimeColumnName() != null) {
                ImmutableList.Builder listBuilder = ImmutableList.builderWithExpectedSize((int)(this.dimensionsMap.size() + 1));
                int i = 0;
                if (i == this.projectionSchema.getTimeColumnPosition()) {
                    listBuilder.add((Object)this.projectionSchema.getTimeColumnName());
                }
                for (String dimName : this.dimensionsMap.keySet()) {
                    listBuilder.add((Object)dimName);
                    if (++i != this.projectionSchema.getTimeColumnPosition()) continue;
                    listBuilder.add((Object)this.projectionSchema.getTimeColumnName());
                }
                return listBuilder.build();
            }
            return ImmutableList.copyOf(this.dimensionsMap.keySet());
        }
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        if ("__time".equals(column) || Objects.equals(column, this.projectionSchema.getTimeColumnName())) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG).setHasNulls(false);
        }
        if (this.dimensionsMap.containsKey(column)) {
            return this.dimensionsMap.get(column).getCapabilities();
        }
        if (this.aggregatorsMap.containsKey(column)) {
            return this.aggregatorsMap.get(column).getCapabilities();
        }
        return null;
    }

    public Map<String, IncrementalIndex.DimensionDesc> getDimensionsMap() {
        return this.dimensionsMap;
    }

    public AggregateProjectionMetadata toMetadata() {
        return new AggregateProjectionMetadata(this.projectionSchema, this.numEntries.get());
    }

    private void validateVirtualColumns(AggregateProjectionSpec projectionSpec, Function<String, IncrementalIndex.DimensionDesc> getBaseTableDimensionDesc) {
        for (VirtualColumn vc : this.projectionSchema.getVirtualColumns().getVirtualColumns()) {
            for (String column : vc.requiredColumns()) {
                if (column.equals(this.projectionSchema.getTimeColumnName()) || column.equals("__time") || getBaseTableDimensionDesc.apply(column) != null) continue;
                throw InvalidInput.exception("projection[%s] contains virtual column[%s] that references an input[%s] which is not a dimension in the base table", projectionSpec.getName(), vc.getOutputName(), column);
            }
        }
    }

    private void initializeAndValidateDimensions(AggregateProjectionSpec projectionSpec, Function<String, IncrementalIndex.DimensionDesc> getBaseTableDimensionDesc) {
        int i = 0;
        for (DimensionSchema dimension : projectionSpec.getGroupingColumns()) {
            if (dimension.getName().equals(this.projectionSchema.getTimeColumnName())) {
                this.columnFormats.put(dimension.getName(), new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG)));
                continue;
            }
            IncrementalIndex.DimensionDesc parent = getBaseTableDimensionDesc.apply(dimension.getName());
            if (parent == null) {
                if (!projectionSpec.getVirtualColumns().exists(dimension.getName())) {
                    throw InvalidInput.exception("projection[%s] contains dimension[%s] that is not present on the base table or a virtual column", projectionSpec.getName(), dimension.getName());
                }
                IncrementalIndex.DimensionDesc childOnly = new IncrementalIndex.DimensionDesc(i++, dimension.getName(), dimension.getDimensionHandler());
                this.dimensions.add(childOnly);
                this.dimensionsMap.put(dimension.getName(), childOnly);
                this.columnFormats.put(dimension.getName(), childOnly.getIndexer().getFormat());
                continue;
            }
            if (!dimension.getColumnType().equals(parent.getCapabilities().toColumnType())) {
                boolean allowAuto = ColumnType.NESTED_DATA.equals(dimension.getColumnType()) && parent.getIndexer() instanceof AutoTypeColumnIndexer;
                InvalidInput.conditionalException(allowAuto, "projection[%s] contains dimension[%s] with different type[%s] than type[%s] in base table", projectionSpec.getName(), dimension.getName(), dimension.getColumnType(), parent.getCapabilities().toColumnType());
            }
            IncrementalIndex.DimensionDesc child = new IncrementalIndex.DimensionDesc(i++, parent.getName(), parent.getHandler(), parent.getIndexer());
            this.dimensions.add(child);
            this.dimensionsMap.put(dimension.getName(), child);
            this.parentDimensionIndex[child.getIndex()] = parent.getIndex();
            this.columnFormats.put(dimension.getName(), child.getIndexer().getFormat());
        }
    }

    private void initializeAndValidateAggregators(AggregateProjectionSpec projectionSpec, Function<String, IncrementalIndex.DimensionDesc> getBaseTableDimensionDesc, Function<String, AggregatorFactory> getBaseTableAggregatorFactory) {
        int i = 0;
        AggregatorFactory[] aggregatorFactoryArray = this.projectionSchema.getAggregators();
        int n = aggregatorFactoryArray.length;
        for (int j = 0; j < n; ++j) {
            AggregatorFactory agg;
            AggregatorFactory aggToUse = agg = aggregatorFactoryArray[j];
            AggregatorFactory baseTableAgg = getBaseTableAggregatorFactory.apply(agg.getName());
            if (baseTableAgg != null) {
                if (!agg.equals(baseTableAgg.getCombiningFactory())) {
                    throw InvalidInput.exception("projection[%s] contains aggregator[%s] that is not the 'combining' aggregator of base table aggregator[%s]", projectionSpec.getName(), agg.getName(), agg.getName());
                }
                aggToUse = baseTableAgg;
            } else {
                for (String column : agg.requiredFields()) {
                    if (column.equals(this.projectionSchema.getTimeColumnName()) || column.equals("__time")) continue;
                    if (getBaseTableAggregatorFactory.apply(column) != null) {
                        throw InvalidInput.exception("projection[%s] contains aggregator[%s] that references aggregator[%s] in base table but this is not supported, projection aggregators which reference base table aggregates must be 'combining' aggregators with the same name as the base table column", projectionSpec.getName(), agg.getName(), column);
                    }
                    if (getBaseTableDimensionDesc.apply(column) != null) continue;
                    if (this.projectionSchema.getVirtualColumns().exists(column)) {
                        throw InvalidInput.exception("projection[%s] contains aggregator[%s] that is has required field[%s] which is a virtual column, this is not yet supported", projectionSpec.getName(), agg.getName(), column);
                    }
                    throw InvalidInput.exception("projection[%s] contains aggregator[%s] that is missing required field[%s] in base table", projectionSpec.getName(), agg.getName(), column);
                }
            }
            IncrementalIndex.MetricDesc metricDesc = new IncrementalIndex.MetricDesc(this.aggregatorsMap.size(), aggToUse);
            this.aggregatorsMap.put(metricDesc.getName(), metricDesc);
            this.columnFormats.put(metricDesc.getName(), new CapabilitiesBasedFormat(metricDesc.getCapabilities()));
            ColumnSelectorFactory factory = agg.getIntermediateType().is(ValueType.COMPLEX) ? new OnheapIncrementalIndex.CachingColumnSelectorFactory(IncrementalIndex.makeColumnSelectorFactory(VirtualColumns.EMPTY, this.inputRowHolder, aggToUse)) : this.virtualSelectorFactory;
            this.aggSelectors.put(aggToUse.getName(), factory);
            this.aggregatorFactories[i++] = aggToUse;
        }
    }

    private long factorizeAggs(AggregatorFactory[] aggregatorFactories, Aggregator[] aggs) {
        long totalInitialSizeBytes = 0L;
        long aggReferenceSize = 8L;
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            AggregatorFactory agg = aggregatorFactories[i];
            AggregatorAndSize aggregatorAndSize = agg.factorizeWithSize(this.aggSelectors.get(agg.getName()));
            aggs[i] = aggregatorAndSize.getAggregator();
            totalInitialSizeBytes += aggregatorAndSize.getInitialSizeBytes();
            totalInitialSizeBytes += 8L;
        }
        return totalInitialSizeBytes;
    }
}

