/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Collections2;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.sha256();

    public static String hashIds(List<DataSegment> segments) {
        Collections.sort(segments);
        Hasher hasher = HASH_FUNCTION.newHasher();
        segments.forEach(segment -> hasher.putString((CharSequence)segment.getId().toString(), StandardCharsets.UTF_8));
        return StringUtils.fromUtf8(hasher.hash().asBytes());
    }

    public static int getVersionFromDir(File inDir) throws IOException {
        File versionFile = new File(inDir, "version.bin");
        if (versionFile.exists()) {
            return Ints.fromByteArray((byte[])Files.toByteArray((File)versionFile));
        }
        File indexFile = new File(inDir, "index.drd");
        if (indexFile.exists()) {
            int version;
            try (FileInputStream in = new FileInputStream(indexFile);){
                version = ((InputStream)in).read();
            }
            return version;
        }
        throw new IOE("Invalid segment dir [%s]. Can't find either of version.bin or index.drd.", inDir);
    }

    @Nullable
    public static Object commaSeparatedIdentifiers(@Nullable Collection<DataSegment> segments) {
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        return Collections2.transform(segments, DataSegment::getId);
    }

    public static Map<Interval, List<DataSegment>> groupSegmentsByInterval(Collection<DataSegment> segments) {
        HashMap<Interval, List<DataSegment>> intervalToSegments = new HashMap<Interval, List<DataSegment>>();
        segments.forEach(segment -> intervalToSegments.computeIfAbsent(segment.getInterval(), k -> new ArrayList()).add(segment));
        return intervalToSegments;
    }

    private SegmentUtils() {
    }
}

