/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.join;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.collections.fastutil.DruidIntList;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.join.JoinConfig;
import org.apache.druid.query.operator.join.JoinPartDefn;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RearrangedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.SortedMatrixMaker;
import org.apache.druid.query.rowsandcols.util.FindResult;

public class SortedInnerJoinOperator
implements Operator {
    private static final Logger log = new Logger(SortedInnerJoinOperator.class);
    private final List<JoinPartDefn> partDefns;
    private final JoinConfig config;

    public SortedInnerJoinOperator(List<JoinPartDefn> partDefns, JoinConfig config) {
        this.partDefns = partDefns;
        this.config = config;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, Operator.Receiver receiver) {
        JoinLogic joinLogic = continuation == null ? new JoinLogic(this.config, this.partDefns) : (JoinLogic)continuation;
        try {
            joinLogic.go(receiver);
            switch (joinLogic.state.ordinal()) {
                case 0: 
                case 3: {
                    throw new ISE("joinLogic.go() exited with state[%s], should never happen.", new Object[]{joinLogic.state});
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return joinLogic;
                }
            }
            throw new ISE("Unknown state[%s]", new Object[]{joinLogic.state});
        }
        catch (RuntimeException e) {
            try {
                joinLogic.close();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private static class JoinLogic
    implements Closeable {
        private final JoinConfig config;
        private final ArrayList<JoinPart> joinParts;
        private State state;
        private int nextPositionToLoad;

        private JoinLogic(JoinConfig config, List<JoinPartDefn> joinParts) {
            this.config = config;
            this.joinParts = new ArrayList(joinParts.size());
            for (JoinPartDefn partDefn : joinParts) {
                this.joinParts.add(new JoinPart(partDefn.getOp(), partDefn.getJoinFields(), partDefn.getProjectFields()));
            }
            this.setNextPositionToLoad(joinParts.size() - 1);
        }

        public void go(final Operator.Receiver receiver) {
            JoinPart joinPart;
            if (this.state == State.PAUSED) {
                this.nextPositionToLoad = -1;
                for (int i = this.joinParts.size() - 1; i >= 0; --i) {
                    joinPart = this.joinParts.get(i);
                    if (!joinPart.needsData()) continue;
                    this.nextPositionToLoad = i;
                    break;
                }
                if (this.nextPositionToLoad == -1) {
                    this.state = State.READY;
                    this.process(receiver);
                    if (this.state == State.PAUSED) {
                        return;
                    }
                }
            }
            block8: while (this.state != State.COMPLETE) {
                int position = this.nextPositionToLoad;
                joinPart = this.joinParts.get(position);
                if (joinPart.curr != null) {
                    throw new ISE("loading data for position[%d], but it already had data!?  Probably a bug!", position);
                }
                joinPart.goOrContinue(new Operator.Receiver(){

                    @Override
                    public Operator.Signal push(RowsAndColumns rac) {
                        joinPart.setCurr(rac);
                        this.process(receiver);
                        switch (state.ordinal()) {
                            case 1: {
                                return Operator.Signal.STOP;
                            }
                            case 0: {
                                return Operator.Signal.GO;
                            }
                            case 2: {
                                return Operator.Signal.PAUSE;
                            }
                            case 3: {
                                throw new ISE("Was in state READY after process returned!?", new Object[0]);
                            }
                        }
                        throw new ISE("Unknown state[%s]", new Object[]{state});
                    }

                    @Override
                    public void completed() {
                        joinPart.complete.set(true);
                    }
                });
                if (joinPart.continuation == null && joinPart.needsData() && joinPart.isComplete()) {
                    this.state = State.COMPLETE;
                }
                switch (this.state.ordinal()) {
                    case 3: {
                        throw new ISE("Don't expect READY state here, process() should've changed it to something else", new Object[0]);
                    }
                    case 2: {
                        return;
                    }
                    case 0: 
                    case 1: {
                        continue block8;
                    }
                }
                throw new ISE("Unknown state[%s]", new Object[]{this.state});
            }
            receiver.completed();
            try {
                this.close();
            }
            catch (IOException e) {
                log.warn("Problem closing stuff, ignoring because we are done anyway.", new Object[0]);
            }
        }

        private void process(Operator.Receiver receiver) {
            for (int i = this.joinParts.size() - 1; i >= 0; --i) {
                JoinPart joinPart = this.joinParts.get(i);
                if (!joinPart.needsData()) continue;
                if (joinPart.isComplete()) {
                    this.state = State.COMPLETE;
                } else {
                    this.setNextPositionToLoad(i);
                }
                return;
            }
            this.state = State.READY;
            DruidIntList[] rowsToInclude = new DruidIntList[this.joinParts.size()];
            for (int i = 0; i < rowsToInclude.length; ++i) {
                rowsToInclude[i] = new DruidIntList(this.config.getBufferSize());
                if (!this.joinParts.get(i).needsData()) continue;
                throw new ISE("doJoin called while joinPart[%d] needed data.  This is likely a bug", i);
            }
            int finalIndex = this.joinParts.size() - 1;
            JoinPart finalPart = this.joinParts.get(finalIndex);
            SortedMatrixMaker.SortedMatrix.MatrixRow row = null;
            while (this.state == State.READY) {
                if (row == null) {
                    row = finalPart.currMatrix.getRow(finalPart.currRowIndex);
                }
                row = this.joinRows(receiver, finalIndex, rowsToInclude, row);
            }
            this.pushRows(receiver, rowsToInclude);
        }

        private void pushRows(Operator.Receiver receiver, DruidIntList[] rowsToInclude) {
            int size = rowsToInclude[0].size();
            if (size == 0) {
                return;
            }
            LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
            for (int i = 0; i < this.joinParts.size(); ++i) {
                JoinPart part = this.joinParts.get(i);
                RearrangedRowsAndColumns remapped = new RearrangedRowsAndColumns(rowsToInclude[i].elements(), 0, rowsToInclude[i].size(), part.curr);
                for (String field : part.projectFields) {
                    cols.put(field, remapped.findColumn(field));
                }
            }
            Operator.Signal signal = receiver.push(new MapOfColumnsRowsAndColumns(cols, size));
            switch (signal) {
                case STOP: {
                    this.state = State.COMPLETE;
                    break;
                }
                case PAUSE: {
                    this.state = State.PAUSED;
                    break;
                }
                case GO: {
                    break;
                }
                default: {
                    throw new ISE("Unknown state[%s]", new Object[]{signal});
                }
            }
        }

        @Nullable
        private SortedMatrixMaker.SortedMatrix.MatrixRow joinRows(Operator.Receiver receiver, int joinPartIndex, DruidIntList[] rowsToInclude, SortedMatrixMaker.SortedMatrix.MatrixRow row) {
            JoinPart joinPart = this.joinParts.get(joinPartIndex);
            FindResult findResult = joinPart.currMatrix.findRow(joinPart.currRowIndex, row);
            if (findResult.wasFound()) {
                joinPart.currRowIndex = findResult.getStartRow();
                joinPart.scanToRowIndex = findResult.getEndRow();
                if (joinPartIndex == 0) {
                    int i;
                    int numRowsExpected = joinPart.scanToRowIndex - joinPart.currRowIndex;
                    for (i = 1; i < this.joinParts.size(); ++i) {
                        JoinPart subPart = this.joinParts.get(i);
                        numRowsExpected *= subPart.scanToRowIndex - subPart.currRowIndex;
                    }
                    if (numRowsExpected == 1) {
                        for (i = 0; i < this.joinParts.size(); ++i) {
                            rowsToInclude[i].add(this.joinParts.get((int)i).currRowIndex);
                        }
                    } else {
                        if (numRowsExpected > 1000000) {
                            throw new IAE("Got a join, with a cartesian product that exceeds 1,000,000 rows, cannot handle it", new Object[0]);
                        }
                        int runSize = 1;
                        for (int partIndex = this.joinParts.size() - 1; partIndex >= 0; --partIndex) {
                            JoinPart part = this.joinParts.get(partIndex);
                            int size = part.scanToRowIndex - part.currRowIndex;
                            if (size == 1) {
                                rowsToInclude[partIndex].fill(part.currRowIndex, numRowsExpected);
                                continue;
                            }
                            int[] vals = new int[size];
                            for (int i2 = 0; i2 < vals.length; ++i2) {
                                vals[i2] = i2 + part.currRowIndex;
                            }
                            int newRunSize = size * runSize;
                            rowsToInclude[partIndex].fillRuns(vals, runSize, numRowsExpected / newRunSize);
                            runSize = newRunSize;
                        }
                    }
                    if (rowsToInclude[0].size() > this.config.getReleaseSize()) {
                        this.pushRows(receiver, rowsToInclude);
                        for (DruidIntList intList : rowsToInclude) {
                            intList.resetToSize(this.config.getBufferSize());
                        }
                    }
                    return null;
                }
                SortedMatrixMaker.SortedMatrix.MatrixRow alternativeRow = this.joinRows(receiver, joinPartIndex - 1, rowsToInclude, row);
                if (this.consumeCurrMaybePush(receiver, joinPartIndex, rowsToInclude, joinPart)) {
                    return null;
                }
                if (alternativeRow == null) {
                    return null;
                }
                FindResult alternativeFind = joinPart.currMatrix.findRow(joinPart.currRowIndex, alternativeRow);
                if (alternativeFind == null) {
                    joinPart.reinitCurr();
                    this.setNextPositionToLoad(joinPartIndex);
                    return null;
                }
                if (alternativeFind.wasFound()) {
                    joinPart.currRowIndex = alternativeFind.getStartRow();
                    joinPart.scanToRowIndex = alternativeFind.getEndRow();
                    return alternativeRow;
                }
                if (this.consumeCurrMaybePush(receiver, joinPartIndex, rowsToInclude, joinPart)) {
                    return null;
                }
                return joinPart.currMatrix.getRow(joinPart.currRowIndex);
            }
            int next = findResult.getNext();
            if (next >= joinPart.currMatrix.numRows()) {
                joinPart.reinitCurr();
                this.setNextPositionToLoad(joinPartIndex);
                return null;
            }
            return joinPart.currMatrix.getRow(next);
        }

        private boolean consumeCurrMaybePush(Operator.Receiver receiver, int joinPartIndex, DruidIntList[] rowsToInclude, JoinPart joinPart) {
            joinPart.jumpTo(joinPart.scanToRowIndex);
            if (joinPart.needsData()) {
                this.pushRows(receiver, rowsToInclude);
                for (DruidIntList intList : rowsToInclude) {
                    intList.clear();
                }
                if (joinPart.isComplete()) {
                    this.state = State.COMPLETE;
                    joinPart.reinitCurr();
                } else {
                    this.setNextPositionToLoad(joinPartIndex);
                }
                return true;
            }
            return false;
        }

        private void setNextPositionToLoad(int joinPartIndex) {
            this.state = State.NEEDS_DATA;
            this.nextPositionToLoad = joinPartIndex;
        }

        @Override
        public void close() throws IOException {
            Closer closer = Closer.create();
            closer.registerAll(this.joinParts);
            closer.close();
        }
    }

    private static enum State {
        NEEDS_DATA,
        COMPLETE,
        PAUSED,
        READY;

    }

    private static class JoinPart
    implements Closeable {
        private final Operator op;
        private final List<String> joinFields;
        private final List<String> projectFields;
        private final AtomicBoolean complete;
        private RowsAndColumns curr;
        private SortedMatrixMaker.SortedMatrix currMatrix;
        private int currRowIndex;
        private int scanToRowIndex;
        private Closeable continuation;

        private JoinPart(Operator op, List<String> joinFields, List<String> projectFields) {
            this.op = op;
            this.joinFields = joinFields;
            this.projectFields = projectFields;
            this.complete = new AtomicBoolean(false);
            this.reinitCurr();
            this.continuation = null;
        }

        public void setCurr(RowsAndColumns rac) {
            if (this.curr != null) {
                throw new ISE("Asked to setCurr even though it was not null!?", new Object[0]);
            }
            this.curr = rac;
            this.currMatrix = SortedMatrixMaker.fromRAC(rac).make(this.joinFields);
            this.jumpTo(0);
        }

        public boolean needsData() {
            return this.curr == null || this.currRowIndex >= this.currMatrix.numRows();
        }

        public boolean isComplete() {
            return this.complete.get();
        }

        public void goOrContinue(Operator.Receiver receiver) {
            Closeable theContinuation = this.continuation;
            this.continuation = null;
            this.continuation = this.op.goOrContinue(theContinuation, receiver);
        }

        @Override
        public void close() throws IOException {
            if (this.continuation != null) {
                this.continuation.close();
            }
        }

        public void jumpTo(int rowIndex) {
            this.currRowIndex = rowIndex;
            this.scanToRowIndex = -1;
        }

        public void reinitCurr() {
            this.curr = null;
            this.currMatrix = null;
            this.currRowIndex = -1;
            this.scanToRowIndex = -1;
        }
    }
}

