/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessor;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesBufferAggregator;

public class CardinalityVectorAggregator
implements VectorAggregator {
    private final List<CardinalityVectorProcessor> processors;

    CardinalityVectorAggregator(List<CardinalityVectorProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        HyperUniquesBufferAggregator.doInit(buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        for (CardinalityVectorProcessor processor : this.processors) {
            processor.aggregate(buf, position, startRow, endRow);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        for (CardinalityVectorProcessor processor : this.processors) {
            processor.aggregate(buf, numRows, positions, rows, positionOffset);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return HyperUniquesBufferAggregator.doGet(buf, position);
    }

    @Override
    public void close() {
    }
}

