/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.BivariateObjectsFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.functional.LongBivariateObjectsFunction;

public final class LongBivariateObjectsFunctionVectorProcessor
extends BivariateObjectsFunctionVectorProcessor<Object[], Object[], long[]> {
    private final LongBivariateObjectsFunction objectsFunction;
    private final boolean[] outNulls;

    public LongBivariateObjectsFunctionVectorProcessor(ExprVectorProcessor<Object[]> left, ExprVectorProcessor<Object[]> right, ExpressionType inputType, LongBivariateObjectsFunction objectsFunction) {
        super(CastToTypeVectorProcessor.cast(left, inputType), CastToTypeVectorProcessor.cast(right, inputType), new long[left.maxVectorSize()]);
        this.objectsFunction = objectsFunction;
        this.outNulls = new boolean[left.maxVectorSize()];
    }

    @Override
    void processIndex(Object[] in1, Object[] in2, int i) {
        Long outVal = this.objectsFunction.process(in1[i], in2[i]);
        if (outVal == null) {
            ((long[])this.outValues)[i] = 0L;
            this.outNulls[i] = true;
        } else {
            ((long[])this.outValues)[i] = outVal;
            this.outNulls[i] = false;
        }
    }

    @Override
    void processNull(int i) {
        ((long[])this.outValues)[i] = 0L;
        this.outNulls[i] = true;
    }

    @Override
    ExprEvalVector<long[]> asEval() {
        return new ExprEvalLongVector((long[])this.outValues, this.outNulls);
    }

    @Override
    public ExpressionType getOutputType() {
        return ExpressionType.LONG;
    }
}

