/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;

public class MapBasedInputRow
extends MapBasedRow
implements InputRow {
    private final List<String> dimensions;

    public MapBasedInputRow(long timestamp, List<String> dimensions, Map<String, Object> event) {
        super(timestamp, event);
        this.dimensions = dimensions;
    }

    public MapBasedInputRow(DateTime timestamp, List<String> dimensions, Map<String, Object> event) {
        super(timestamp, event);
        this.dimensions = dimensions;
    }

    @Override
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapBasedInputRow that = (MapBasedInputRow)o;
        return Objects.equals(this.dimensions, that.dimensions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dimensions);
    }

    @Override
    public String toString() {
        return "{timestamp=" + String.valueOf(DateTimes.utc(this.getTimestampFromEpoch())) + ", event=" + String.valueOf(this.getEvent()) + ", dimensions=" + String.valueOf(this.dimensions) + "}";
    }
}

