/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.lookup;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.lookup.LookupInputSlice;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;

public class LookupInputSliceReader
implements InputSliceReader {
    private static final Logger log = new Logger(LookupInputSliceReader.class);
    private final SegmentWrangler segmentWrangler;

    public LookupInputSliceReader(SegmentWrangler segmentWrangler) {
        this.segmentWrangler = segmentWrangler;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        return 1;
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        String lookupName = ((LookupInputSlice)slice).getLookupName();
        return ReadableInputs.segments(() -> Iterators.singletonIterator((Object)ReadableInput.segment(new SegmentWithDescriptor(() -> {
            Iterable segments = this.segmentWrangler.getSegmentsForIntervals((DataSource)new LookupDataSource(lookupName), (Iterable)Intervals.ONLY_ETERNITY);
            Iterator segmentIterator = segments.iterator();
            if (!segmentIterator.hasNext()) {
                throw new ISE("Lookup[%s] is not loaded", new Object[]{lookupName});
            }
            Segment segment = (Segment)segmentIterator.next();
            if (segmentIterator.hasNext()) {
                CloseableUtils.closeAndSuppressExceptions((Closeable)segment, e -> log.warn(e, "Failed to close segment for lookup[%s]", new Object[]{lookupName}));
                throw new ISE("Lookup[%s] has multiple segments; cannot read", new Object[]{lookupName});
            }
            return ResourceHolder.fromCloseable((Closeable)new CompleteSegment(null, segment));
        }, new RichSegmentDescriptor(SegmentId.dummy((String)lookupName).toDescriptor(), null)))));
    }
}

