/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.runtime1.dpath.ByteToLong$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.DecimalToLong$;
import org.apache.daffodil.runtime1.dpath.FNOneArg;
import org.apache.daffodil.runtime1.dpath.HexBinaryToString$;
import org.apache.daffodil.runtime1.dpath.HexStringToLong$;
import org.apache.daffodil.runtime1.dpath.IntToLong$;
import org.apache.daffodil.runtime1.dpath.IntegerToLong$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.ShortToLong$;
import org.apache.daffodil.runtime1.dpath.StringToLong$;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public abstract class DFDLConstructorFunction
extends FNOneArg {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DFDLConstructorFunction.class.getDeclaredField("hexMsg$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DFDLConstructorFunction.class.getDeclaredField("nfeMsg$lzy1"));
    private volatile Object nfeMsg$lzy1;
    private volatile Object hexMsg$lzy1;

    public DFDLConstructorFunction(CompiledDPath recipe, NodeInfo.Kind argType) {
        super(recipe, argType);
    }

    public abstract String constructorName();

    public abstract int maxHexDigits();

    public String nfeMsg() {
        Object object = this.nfeMsg$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.nfeMsg$lzyINIT1();
    }

    private Object nfeMsg$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.nfeMsg$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "%s cannot be cast to dfdl:" + this.constructorName() + "\ndfdl:" + this.constructorName() + " received an unrecognized type! Must be String, Byte, Short, Integer, Long or a subtype thereof.";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nfeMsg$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String hexMsg() {
        Object object = this.hexMsg$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.hexMsg$lzyINIT1();
    }

    private Object hexMsg$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hexMsg$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "dfdl:" + this.constructorName() + " received string violates maximum hex digits.  Received %s expected a max of " + this.maxHexDigits();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hexMsg$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract Object convert(Long var1, DState var2);

    @Override
    public Object computeValue(Object a, DState dstate) {
        Long l;
        Object object = DataValue$.MODULE$.getAnyRef$extension(a);
        if (object instanceof Byte) {
            l = ByteToLong$.MODULE$.computeValue(a, dstate);
        } else if (object instanceof Short) {
            l = ShortToLong$.MODULE$.computeValue(a, dstate);
        } else if (object instanceof Integer) {
            l = IntToLong$.MODULE$.computeValue(a, dstate);
        } else if (object instanceof Long) {
            Long l2 = (Long)object;
            l = DataValue$.MODULE$.toDataValue(l2);
        } else if (object instanceof String) {
            String s = (String)object;
            if (s.trim().startsWith("x")) {
                String hexStr = s.trim().substring(1);
                if (hexStr.length() > this.maxHexDigits()) {
                    throw new NumberFormatException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this.hexMsg()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)hexStr.length())})));
                }
                l = HexStringToLong$.MODULE$.computeValue(DataValue$.MODULE$.toDataValue(hexStr), dstate);
            } else {
                l = StringToLong$.MODULE$.computeValue(a, dstate);
            }
        } else if (object instanceof BigInteger) {
            l = IntegerToLong$.MODULE$.computeValue(a, dstate);
        } else if (object instanceof BigDecimal) {
            l = DecimalToLong$.MODULE$.computeValue(a, dstate);
        } else {
            if (object instanceof byte[]) {
                byte[] hb = (byte[])object;
                String string = HexBinaryToString$.MODULE$.computeValue(DataValue$.MODULE$.toDataValue(hb), dstate);
                String str = "0x" + DataValue$.MODULE$.getString$extension(string);
                throw new NumberFormatException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this.nfeMsg()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            Object x = object;
            throw new NumberFormatException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this.nfeMsg()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x})));
        }
        Long l3 = l;
        return this.convert(l3, dstate);
    }
}

