/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.RecordType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class TypeChecker {
    public Expression staticTypeCheck(Expression supplied, SequenceType req, Supplier<RoleDiagnostic> roleSupplier, ExpressionVisitor visitor) throws XPathException {
        String msg;
        RoleDiagnostic role;
        Affinity relation;
        RoleDiagnostic role2;
        Expression cexp;
        boolean cardOK;
        if (supplied.implementsStaticTypeCheck()) {
            return supplied.staticTypeCheck(req, false, roleSupplier, visitor);
        }
        StaticContext env = visitor.getStaticContext();
        Configuration config = env.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (supplied instanceof Literal && ((Literal)supplied).isInstance(req, th)) {
            return supplied;
        }
        Expression exp = supplied;
        ContextItemStaticInfo defaultContextInfo = config.getDefaultContextItemStaticInfo();
        boolean allow40 = env.getXPathVersion() >= 40;
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        boolean itemTypeOK = reqItemType instanceof AnyItemType;
        if (reqCard == 8192) {
            itemTypeOK = true;
        }
        if (!itemTypeOK) {
            suppliedItemType = exp.getItemType();
            if (reqItemType == null || suppliedItemType == null) {
                throw new NullPointerException();
            }
            Affinity affinity = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = affinity == Affinity.SAME_TYPE || affinity == Affinity.SUBSUMES;
        }
        if (reqItemType.isPlainType()) {
            Expression cexp2;
            if (!itemTypeOK && !suppliedItemType.isPlainType() && suppliedCard != 8192) {
                boolean atomizable = suppliedItemType.isAtomizable(th);
                if (atomizable && (exp.getSpecialProperties() & 0x10000000) != 0) {
                    atomizable = false;
                }
                if (!atomizable) {
                    String shortItemType = suppliedItemType instanceof RecordType ? "a record type" : (suppliedItemType instanceof MapType ? "a map type" : (suppliedItemType instanceof FunctionItemType ? "a function type" : (suppliedItemType instanceof NodeTest ? "an element type with element-only content" : suppliedItemType.toString())));
                    RoleDiagnostic role3 = roleSupplier.get();
                    throw new XPathException("An atomic value is required for the " + role3.getMessage() + ", but the supplied type is " + shortItemType + ", which cannot be atomized").withErrorCode("FOTY0013").withLocation(supplied.getLocation()).asTypeError().withFailingExpression(supplied);
                }
                if (exp.getRetainedStaticContext() == null) {
                    exp.setRetainedStaticContextLocally(env.makeRetainedStaticContext());
                }
                cexp = Atomizer.makeAtomizer(exp, roleSupplier);
                ExpressionTool.copyLocationInfo(exp, cexp);
                exp = cexp;
                cexp = exp.simplify();
                ExpressionTool.copyLocationInfo(exp, cexp);
                exp = cexp;
                suppliedItemType = exp.getItemType();
                suppliedCard = exp.getCardinality();
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
            if (reqItemType instanceof BuiltInAtomicType && ((BuiltInAtomicType)reqItemType).isPrimitiveType() && !itemTypeOK) {
                int rt = ((BuiltInAtomicType)reqItemType).getFingerprint();
                UType promotables = this.promotableTypes(rt, allow40);
                if (suppliedItemType.getUType().intersection(promotables).equals(UType.VOID)) {
                    RoleDiagnostic role4 = roleSupplier.get();
                    throw new XPathException("An item of type " + suppliedItemType + " cannot be converted to " + reqItemType + " as required for the " + role4.getMessage()).withErrorCode(role4.getErrorCode()).withLocation(supplied.getLocation()).withFailingExpression(supplied);
                }
                ConversionRules rules = config.getConversionRules();
                Expression promoted = null;
                Converter converter = TypeChecker.makePromotingConverter(suppliedItemType, rt, rules, allow40);
                if (converter != null) {
                    promoted = TypeChecker.makePromoter(exp, converter, (BuiltInAtomicType)reqItemType);
                }
                if (promoted != null) {
                    if (promoted instanceof AtomicSequenceConverter) {
                        ((AtomicSequenceConverter)promoted).setRoleDiagnostic(roleSupplier);
                    }
                    exp = promoted;
                    try {
                        exp = exp.simplify().typeCheck(visitor, defaultContextInfo);
                    }
                    catch (XPathException err) {
                        throw err.maybeWithLocation(exp.getLocation()).asStaticError().withFailingExpression(supplied);
                    }
                    suppliedItemType = reqItemType;
                    suppliedCard = -1;
                    itemTypeOK = true;
                }
            }
            if (!itemTypeOK) {
                if (suppliedItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                    block63: {
                        if (((PlainType)reqItemType).isNamespaceSensitive()) {
                            role2 = roleSupplier.get();
                            throw new XPathException("An untyped atomic value cannot be converted to a QName or NOTATION as required for the " + role2.getMessage()).withErrorCode("XPTY0117").withLocation(supplied.getLocation()).withFailingExpression(supplied);
                        }
                        cexp2 = UntypedSequenceConverter.makeUntypedSequenceConverter(config, exp, (PlainType)reqItemType);
                        ((AtomicSequenceConverter)cexp2).setRoleDiagnostic(roleSupplier);
                        ExpressionTool.copyLocationInfo(exp, cexp2);
                        try {
                            if (exp instanceof Literal) {
                                try {
                                    exp = Literal.makeLiteral(SequenceTool.toGroundedValue(((AtomicSequenceConverter)cexp2).iterate(visitor.makeDynamicContext())), exp);
                                    ExpressionTool.copyLocationInfo(cexp2, exp);
                                    break block63;
                                }
                                catch (UncheckedXPathException e) {
                                    throw e.getXPathException();
                                }
                            }
                            exp = cexp2;
                        }
                        catch (XPathException err) {
                            throw err.maybeWithLocation(exp.getLocation()).withFailingExpression(supplied).maybeWithErrorCode(roleSupplier.get().getErrorCode()).asStaticError();
                        }
                    }
                    itemTypeOK = true;
                    suppliedItemType = reqItemType;
                }
                if (suppliedItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !exp.hasSpecialProperty(0x4000000)) {
                    UntypedSequenceConverter conversion;
                    if (((PlainType)reqItemType).isNamespaceSensitive()) {
                        conversion = UntypedSequenceConverter.makeUntypedSequenceRejector(config, exp, (PlainType)reqItemType);
                    } else {
                        UntypedSequenceConverter usc = UntypedSequenceConverter.makeUntypedSequenceConverter(config, exp, (PlainType)reqItemType);
                        usc.setRoleDiagnostic(roleSupplier);
                        conversion = usc;
                    }
                    ExpressionTool.copyLocationInfo(exp, conversion);
                    try {
                        if (exp instanceof Literal) {
                            try {
                                exp = Literal.makeLiteral(SequenceTool.toGroundedValue(((Expression)conversion).iterate(visitor.makeDynamicContext())), exp);
                                ExpressionTool.copyLocationInfo(supplied, exp);
                            }
                            catch (UncheckedXPathException e) {
                                throw e.getXPathException();
                            }
                        } else {
                            exp = conversion;
                        }
                        suppliedItemType = exp.getItemType();
                    }
                    catch (XPathException err) {
                        throw err.maybeWithLocation(exp.getLocation()).asStaticError();
                    }
                }
            }
            if (!itemTypeOK && reqItemType.getBasicAlphaCode().length() > 2 && visitor.getStaticContext().getXPathVersion() >= 40 && reqItemType.getUType().overlaps(suppliedItemType.getUType())) {
                itemTypeOK = true;
                cexp2 = this.makeDownCaster(exp, (AtomicType)reqItemType, config);
                if (cexp2 instanceof AtomicSequenceConverter) {
                    ((AtomicSequenceConverter)cexp2).setRoleDiagnostic(roleSupplier);
                }
                ExpressionTool.copyLocationInfo(exp, cexp2);
                exp = cexp2;
                try {
                    exp = exp.simplify().typeCheck(visitor, defaultContextInfo);
                }
                catch (XPathException err) {
                    throw err.maybeWithLocation(exp.getLocation()).asStaticError().withFailingExpression(supplied);
                }
                suppliedItemType = reqItemType;
            }
        } else if (!itemTypeOK && reqItemType instanceof FunctionItemType && !((FunctionItemType)reqItemType).isMapType() && !((FunctionItemType)reqItemType).isArrayType()) {
            Affinity r = th.relationship(suppliedItemType, th.getGenericFunctionItemType());
            if (r != Affinity.DISJOINT) {
                if (!(suppliedItemType instanceof FunctionItemType)) {
                    exp = new ItemChecker(exp, th.getGenericFunctionItemType(), roleSupplier);
                    suppliedItemType = th.getGenericFunctionItemType();
                }
                exp = TypeChecker.makeFunctionSequenceCoercer(exp, (FunctionItemType)reqItemType, roleSupplier, allow40);
                itemTypeOK = true;
            }
        } else if (!itemTypeOK && reqItemType instanceof JavaExternalObjectType && reqCard == 16384) {
            if (Sequence.class.isAssignableFrom(((JavaExternalObjectType)reqItemType).getJavaClass())) {
                itemTypeOK = true;
            } else if (supplied instanceof FunctionCall && ((FunctionCall)supplied).adjustRequiredType((JavaExternalObjectType)reqItemType)) {
                itemTypeOK = true;
                cardOK = true;
            }
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            role2 = roleSupplier.get();
            throw new XPathException("An empty sequence is not allowed as the " + role2.getMessage()).withErrorCode(role2.getErrorCode()).withLocation(supplied.getLocation()).asTypeErrorIf(role2.isTypeError()).withFailingExpression(supplied);
        }
        Affinity affinity = relation = itemTypeOK ? Affinity.SUBSUMED_BY : th.relationship(suppliedItemType, reqItemType);
        if (reqCard == 8192) {
            relation = Affinity.SAME_TYPE;
        }
        if (relation == Affinity.DISJOINT) {
            role = roleSupplier.get();
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    msg = role.composeErrorMessage(reqItemType, supplied, th);
                    msg = msg + ". The expression can succeed only if the supplied value is an empty sequence.";
                    visitor.issueWarning(msg, "SXWN9026", supplied.getLocation());
                }
            } else {
                msg = role.composeErrorMessage(reqItemType, supplied, th);
                throw new XPathException(msg).withErrorCode(role.getErrorCode()).withLocation(supplied.getLocation()).asTypeErrorIf(role.isTypeError()).withFailingExpression(supplied);
            }
        }
        if (relation != Affinity.SAME_TYPE && relation != Affinity.SUBSUMED_BY) {
            if (exp instanceof Literal) {
                if (req.matches(((Literal)exp).getGroundedValue(), th)) {
                    return exp;
                }
                role = roleSupplier.get();
                msg = role.composeErrorMessage(reqItemType, supplied, th);
                throw new XPathException(msg).withErrorCode(role.getErrorCode()).withLocation(supplied.getLocation()).asTypeErrorIf(role.isTypeError()).withFailingExpression(supplied);
            }
            cexp = new ItemChecker(exp, reqItemType, roleSupplier);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                role = roleSupplier.get();
                throw new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.describe(reqCard) + "; supplied value has cardinality " + Cardinality.describe(suppliedCard)).withErrorCode(role.getErrorCode()).withLocation(supplied.getLocation()).withFailingExpression(supplied).asTypeErrorIf(role.isTypeError());
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, roleSupplier);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        return exp;
    }

    public static Converter makePromotingConverter(ItemType suppliedItemType, int requiredType, ConversionRules rules, boolean allow40) {
        switch (requiredType) {
            case 517: {
                return new Converter.PromoterToDouble(rules);
            }
            case 516: {
                return new Converter.PromoterToFloat(rules);
            }
            case 513: {
                return new Converter.PromoterToString();
            }
            case 529: {
                if (!allow40) break;
                return new Converter.PromoterToAnyURI();
            }
            case 527: {
                if (!allow40) break;
                return new Converter.PromoterToHexBinary();
            }
            case 528: {
                if (!allow40) break;
                return new Converter.PromoterToBase64Binary();
            }
        }
        return null;
    }

    public Expression makeArithmeticExpression(Expression lhs, int operator, Expression rhs) {
        return new ArithmeticExpression(lhs, operator, rhs);
    }

    public Expression makeGeneralComparison(Expression lhs, int operator, Expression rhs) {
        return new GeneralComparison20(lhs, operator, rhs);
    }

    public Expression processValueOf(Expression select, Configuration config) {
        return select;
    }

    private static Expression makeFunctionSequenceCoercer(Expression exp, FunctionItemType reqItemType, Supplier<RoleDiagnostic> role, boolean allow40) throws XPathException {
        return reqItemType.makeFunctionSequenceCoercer(exp, role, allow40);
    }

    private Expression makeDownCaster(Expression exp, AtomicType reqItemType, Configuration config) {
        return AtomicSequenceConverter.makeDownCaster(exp, reqItemType, config);
    }

    public static Expression strictTypeCheck(Expression supplied, SequenceType req, Supplier<RoleDiagnostic> roleSupplier, StaticContext env) throws XPathException {
        Expression cexp;
        RoleDiagnostic role;
        boolean itemTypeOK;
        boolean cardOK;
        Expression exp = supplied;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = req.getPrimaryType() instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType();
            Affinity affinity = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = affinity == Affinity.SAME_TYPE || affinity == Affinity.SUBSUMES;
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = suppliedItemType instanceof ErrorType ? 8192 : exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedItemType == null) {
            suppliedItemType = exp.getItemType();
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            RoleDiagnostic role2 = roleSupplier.get();
            XPathException err = new XPathException("An empty sequence is not allowed as the " + role2.getMessage(), role2.getErrorCode(), supplied.getLocation());
            err.setIsTypeError(role2.isTypeError());
            throw err;
        }
        Affinity relation = th.relationship(suppliedItemType, reqItemType);
        if (relation == Affinity.DISJOINT) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    role = roleSupplier.get();
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType + "; supplied value (" + supplied.toShortString() + ") has item type " + suppliedItemType + ". The expression can succeed only if the supplied value is an empty sequence.";
                    env.issueWarning(msg, "SXWN9026", supplied.getLocation());
                }
            } else {
                RoleDiagnostic role3 = roleSupplier.get();
                String msg = role3.composeErrorMessage(reqItemType, supplied, th);
                XPathException err = new XPathException(msg, role3.getErrorCode(), supplied.getLocation());
                err.setIsTypeError(role3.isTypeError());
                throw err;
            }
        }
        if (relation != Affinity.SAME_TYPE && relation != Affinity.SUBSUMED_BY) {
            cexp = new ItemChecker(exp, reqItemType, roleSupplier);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                role = roleSupplier.get();
                XPathException err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.describe(reqCard) + "; supplied value has cardinality " + Cardinality.describe(suppliedCard), role.getErrorCode(), supplied.getLocation());
                err.setIsTypeError(role.isTypeError());
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, roleSupplier);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        return exp;
    }

    public static XPathException testConformance(Sequence val, SequenceType requiredType, XPathContext context) throws XPathException {
        Item item;
        ItemType reqItemType = requiredType.getPrimaryType();
        SequenceIterator iter = val.iterate();
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (reqItemType.matches(item, context.getConfiguration().getTypeHierarchy())) continue;
            return new XPathException("Required type is " + reqItemType + "; supplied value has type " + UType.getUType(val.materialize())).asTypeError().withErrorCode("XPTY0004");
        }
        int reqCardinality = requiredType.getCardinality();
        if (count == 0 && !Cardinality.allowsZero(reqCardinality)) {
            return new XPathException("Required type does not allow empty sequence, but supplied value is empty").asTypeError().withErrorCode("XPTY0004");
        }
        if (count > 1 && !Cardinality.allowsMany(reqCardinality)) {
            return new XPathException("Required type requires a singleton sequence; supplied value contains " + count + " items").asTypeError().withErrorCode("XPTY0004");
        }
        if (count > 0 && reqCardinality == 8192) {
            return new XPathException("Required type requires an empty sequence, but supplied value is non-empty").asTypeError().withErrorCode("XPTY0004");
        }
        return null;
    }

    public static XPathException ebvError(Expression exp, TypeHierarchy th) {
        if (Cardinality.allowsZero(exp.getCardinality())) {
            return null;
        }
        ItemType t = exp.getItemType();
        if (th.relationship(t, Type.NODE_TYPE) == Affinity.DISJOINT && th.relationship(t, BuiltInAtomicType.BOOLEAN) == Affinity.DISJOINT && th.relationship(t, BuiltInAtomicType.STRING) == Affinity.DISJOINT && th.relationship(t, BuiltInAtomicType.ANY_URI) == Affinity.DISJOINT && th.relationship(t, BuiltInAtomicType.UNTYPED_ATOMIC) == Affinity.DISJOINT && th.relationship(t, NumericType.getInstance()) == Affinity.DISJOINT && !(t instanceof JavaExternalObjectType)) {
            return new XPathException("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes").withErrorCode("FORG0006").asTypeError();
        }
        return null;
    }

    private static Expression makePromoter(Expression exp, Converter converter, BuiltInAtomicType type) {
        ConversionResult result;
        ConversionRules rules = exp.getConfiguration().getConversionRules();
        converter.setConversionRules(rules);
        if (exp instanceof Literal && ((Literal)exp).getGroundedValue() instanceof AtomicValue && (result = converter.convert((AtomicValue)((Literal)exp).getGroundedValue())) instanceof AtomicValue) {
            Literal converted = Literal.makeLiteral((AtomicValue)result, exp);
            ExpressionTool.copyLocationInfo(exp, converted);
            return converted;
        }
        AtomicSequenceConverter asc = new AtomicSequenceConverter(exp, type);
        asc.setConverter(converter);
        ExpressionTool.copyLocationInfo(exp, asc);
        return asc;
    }

    private UType promotableTypes(int targetType, boolean allow40) {
        if (allow40) {
            switch (targetType) {
                case 517: {
                    return UType.UNTYPED_ATOMIC.union(UType.DECIMAL).union(UType.FLOAT).union(UType.DOUBLE);
                }
                case 516: {
                    return UType.UNTYPED_ATOMIC.union(UType.DECIMAL).union(UType.FLOAT);
                }
                case 513: 
                case 529: {
                    return UType.UNTYPED_ATOMIC.union(UType.ANY_URI).union(UType.STRING);
                }
                case 527: 
                case 528: {
                    return UType.UNTYPED_ATOMIC.union(UType.HEX_BINARY).union(UType.BASE64_BINARY);
                }
            }
            return UType.UNTYPED_ATOMIC.union(UType.fromTypeCode(targetType));
        }
        switch (targetType) {
            case 517: {
                return UType.UNTYPED_ATOMIC.union(UType.DECIMAL).union(UType.FLOAT).union(UType.DOUBLE);
            }
            case 516: {
                return UType.UNTYPED_ATOMIC.union(UType.DECIMAL).union(UType.FLOAT);
            }
            case 513: {
                return UType.UNTYPED_ATOMIC.union(UType.STRING).union(UType.ANY_URI);
            }
        }
        return UType.UNTYPED_ATOMIC.union(UType.fromTypeCode(targetType));
    }
}

