/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.dropwizard;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.metrics.MetricsContext;

public class DropwizardMetricsContext
implements MetricsContext,
Closeable {
    protected Counter inFlight;
    protected Timer totals;
    protected Timer uncheckedApplicationFaults;
    protected Timer checkedApplicationFaults;
    protected Timer runtimeFaults;
    protected Timer logicalRuntimeFaults;
    protected Meter incomingData;
    protected Meter outgoingData;
    protected final String baseName;
    protected final MetricRegistry registry;

    public DropwizardMetricsContext(String prefix, MetricRegistry registry) {
        this.baseName = prefix;
        this.registry = registry;
        this.totals = registry.timer(this.baseName + "Attribute=Totals");
        this.uncheckedApplicationFaults = registry.timer(this.baseName + "Attribute=Unchecked Application Faults");
        this.checkedApplicationFaults = registry.timer(this.baseName + "Attribute=Checked Application Faults");
        this.runtimeFaults = registry.timer(this.baseName + "Attribute=Runtime Faults");
        this.logicalRuntimeFaults = registry.timer(this.baseName + "Attribute=Logical Runtime Faults");
        this.inFlight = registry.counter(this.baseName + "Attribute=In Flight");
        this.incomingData = registry.meter(this.baseName + "Attribute=Data Read");
        this.outgoingData = registry.meter(this.baseName + "Attribute=Data Written");
    }

    @Override
    public void close() throws IOException {
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, "Attribute=Totals"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, "Attribute=Unchecked Application Faults"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, this.baseName + "Attribute=Checked Application Faults"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, this.baseName + "Attribute=Runtime Faults"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, this.baseName + "Attribute=Logical Runtime Faults"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, this.baseName + "Attribute=In Flight"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, this.baseName + "Attribute=Data Read"}));
        this.registry.remove(MetricName.build((String[])new String[]{this.baseName, this.baseName + "Attribute=Data Written"}));
    }

    @Override
    public void start(Exchange ex) {
        this.inFlight.inc();
    }

    @Override
    public void stop(long timeInNS, long inSize, long outSize, Exchange ex) {
        FaultMode fm;
        this.totals.update(timeInNS, TimeUnit.NANOSECONDS);
        if (inSize != -1L) {
            this.incomingData.mark(inSize);
        }
        if (outSize != -1L) {
            this.outgoingData.mark(outSize);
        }
        if ((fm = (FaultMode)ex.get(FaultMode.class)) == null && ex.getOutFaultMessage() != null) {
            fm = (FaultMode)ex.getOutFaultMessage().get(FaultMode.class);
        }
        if (fm == null && ex.getInMessage() != null) {
            fm = (FaultMode)ex.getInMessage().get(FaultMode.class);
        }
        if (fm != null) {
            switch (fm) {
                case CHECKED_APPLICATION_FAULT: {
                    this.checkedApplicationFaults.update(timeInNS, TimeUnit.NANOSECONDS);
                    break;
                }
                case UNCHECKED_APPLICATION_FAULT: {
                    this.uncheckedApplicationFaults.update(timeInNS, TimeUnit.NANOSECONDS);
                    break;
                }
                case RUNTIME_FAULT: {
                    this.runtimeFaults.update(timeInNS, TimeUnit.NANOSECONDS);
                    break;
                }
                case LOGICAL_RUNTIME_FAULT: {
                    this.logicalRuntimeFaults.update(timeInNS, TimeUnit.NANOSECONDS);
                    break;
                }
            }
        }
        this.inFlight.dec();
    }

    public Counter getInFlight() {
        return this.inFlight;
    }

    public Timer getTotals() {
        return this.totals;
    }

    public Timer getUncheckedApplicationFaults() {
        return this.uncheckedApplicationFaults;
    }

    public Timer getCheckedApplicationFaults() {
        return this.checkedApplicationFaults;
    }

    public Timer getRuntimeFaults() {
        return this.runtimeFaults;
    }

    public Timer getLogicalRuntimeFaults() {
        return this.logicalRuntimeFaults;
    }

    public Meter getIncomingData() {
        return this.incomingData;
    }

    public Meter getOutgoingData() {
        return this.outgoingData;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }
}

