/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EmbeddedSlotMap;
import org.mozilla.javascript.HashSlotMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;
import org.mozilla.javascript.ThreadSafeEmbeddedSlotMap;
import org.mozilla.javascript.ThreadSafeHashSlotMap;

public abstract class SlotMapOwner {
    private static final long serialVersionUID = 1L;
    static final int LARGE_HASH_SIZE = 1536;
    static final SlotMap EMPTY_SLOT_MAP = new EmptySlotMap();
    static final SlotMap THREAD_SAFE_EMPTY_SLOT_MAP = new ThreadSafeEmptySlotMap();
    private SlotMap slotMap;

    protected SlotMapOwner() {
        this.slotMap = SlotMapOwner.createSlotMap(0);
    }

    protected SlotMapOwner(int capacity) {
        this.slotMap = SlotMapOwner.createSlotMap(capacity);
    }

    protected SlotMapOwner(SlotMap map) {
        this.slotMap = map;
    }

    protected static SlotMap createSlotMap(int initialSize) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(17)) {
            if (initialSize == 0) {
                return THREAD_SAFE_EMPTY_SLOT_MAP;
            }
            if (initialSize > 1536) {
                return new ThreadSafeHashSlotMap(initialSize);
            }
            return new ThreadSafeEmbeddedSlotMap();
        }
        if (initialSize == 0) {
            return EMPTY_SLOT_MAP;
        }
        if (initialSize > 1536) {
            return new HashSlotMap();
        }
        return new EmbeddedSlotMap();
    }

    final SlotMap getMap() {
        return this.slotMap;
    }

    final void setMap(SlotMap newMap) {
        this.slotMap = newMap;
    }

    final CompoundOperationMap startCompoundOp(boolean forWriting) {
        return this.slotMap.startCompoundOp(this, forWriting);
    }

    private static class EmptySlotMap
    implements SlotMap {
        private EmptySlotMap() {
        }

        @Override
        public Iterator<Slot> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
            Slot newSlot = new Slot(key, index, attributes);
            SingleEntrySlotMap map = new SingleEntrySlotMap(newSlot);
            owner.setMap(map);
            return newSlot;
        }

        @Override
        public Slot query(Object key, int index) {
            return null;
        }

        @Override
        public void add(SlotMapOwner owner, Slot newSlot) {
            if (newSlot != null) {
                SingleEntrySlotMap map = new SingleEntrySlotMap(newSlot);
                owner.setMap(map);
            }
        }

        @Override
        public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap compoundOp, Object key, int index, SlotMap.SlotComputer<S> c) {
            S newSlot = c.compute(key, index, null, compoundOp, owner);
            if (newSlot != null) {
                if (!compoundOp.isTouched()) {
                    SingleEntrySlotMap map = new SingleEntrySlotMap((Slot)newSlot);
                    owner.setMap(map);
                } else {
                    compoundOp.add(owner, (Slot)newSlot);
                }
            }
            return newSlot;
        }
    }

    private static final class ThreadSafeEmptySlotMap
    extends EmptySlotMap {
        private ThreadSafeEmptySlotMap() {
        }

        @Override
        public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
            Slot newSlot = new Slot(key, index, attributes);
            SlotMap currentMap = this.replaceMapAndAddSlot(owner, newSlot);
            if (currentMap != this) {
                return currentMap.modify(owner, key, index, attributes);
            }
            return newSlot;
        }

        @Override
        public void add(SlotMapOwner owner, Slot newSlot) {
            SlotMap currentMap;
            if (newSlot != null && (currentMap = this.replaceMapAndAddSlot(owner, newSlot)) != this) {
                currentMap.add(owner, newSlot);
            }
        }

        @Override
        public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap compoundOp, Object key, int index, SlotMap.SlotComputer<S> c) {
            SlotMap currentMap;
            S newSlot = c.compute(key, index, null, compoundOp, owner);
            if (newSlot != null && (currentMap = this.replaceMapAndAddSlot(owner, (Slot)newSlot)) != this) {
                return currentMap.compute(owner, key, index, c);
            }
            return newSlot;
        }

        private SlotMap replaceMapAndAddSlot(SlotMapOwner owner, Slot newSlot) {
            ThreadSafeSingleEntrySlotMap map = new ThreadSafeSingleEntrySlotMap(newSlot);
            return ThreadedAccess.checkAndReplaceMap(owner, this, map);
        }

        @Override
        public CompoundOperationMap startCompoundOp(SlotMapOwner owner, boolean forWriting) {
            ThreadSafeEmbeddedSlotMap map = new ThreadSafeEmbeddedSlotMap();
            return ThreadedAccess.checkAndReplaceMap(owner, this, map).startCompoundOp(owner, forWriting);
        }
    }

    static final class ThreadSafeSingleEntrySlotMap
    extends SingleEntrySlotMap {
        ThreadSafeSingleEntrySlotMap(Slot slot) {
            super(slot);
        }

        @Override
        public void add(SlotMapOwner owner, Slot newSlot) {
            if (owner == null) {
                throw new IllegalStateException();
            }
            ThreadSafeEmbeddedSlotMap newMap = new ThreadSafeEmbeddedSlotMap(2);
            newMap.add(null, this.slot);
            SlotMap currentMap = ThreadedAccess.checkAndReplaceMap(owner, this, newMap);
            if (currentMap == this) {
                newMap.add(owner, newSlot);
            } else {
                currentMap.add(owner, newSlot);
            }
        }

        @Override
        public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap compoundOp, Object key, int index, SlotMap.SlotComputer<S> c) {
            SlotMap currentMap = this.checkAndReplaceMap(owner);
            return currentMap.compute(owner, compoundOp, key, index, c);
        }

        @Override
        public CompoundOperationMap startCompoundOp(SlotMapOwner owner, boolean forWriting) {
            return this.checkAndReplaceMap(owner).startCompoundOp(owner, forWriting);
        }

        private SlotMap checkAndReplaceMap(SlotMapOwner owner) {
            ThreadSafeEmbeddedSlotMap newMap = new ThreadSafeEmbeddedSlotMap(2);
            newMap.add(null, this.slot);
            SlotMap currentMap = ThreadedAccess.checkAndReplaceMap(owner, this, newMap);
            return currentMap;
        }
    }

    static class SingleEntrySlotMap
    implements SlotMap {
        protected final Slot slot;

        SingleEntrySlotMap(Slot slot) {
            assert (slot != null);
            this.slot = slot;
        }

        @Override
        public Iterator<Slot> iterator() {
            return new Iter(this.slot);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
            int indexOrHash;
            int n = indexOrHash = key != null ? key.hashCode() : index;
            if (indexOrHash == this.slot.indexOrHash && Objects.equals(this.slot.name, key)) {
                return this.slot;
            }
            Slot newSlot = new Slot(key, index, attributes);
            this.add(owner, newSlot);
            return newSlot;
        }

        @Override
        public Slot query(Object key, int index) {
            int indexOrHash;
            int n = indexOrHash = key != null ? key.hashCode() : index;
            if (indexOrHash == this.slot.indexOrHash && Objects.equals(this.slot.name, key)) {
                return this.slot;
            }
            return null;
        }

        @Override
        public void add(SlotMapOwner owner, Slot newSlot) {
            if (owner == null) {
                throw new IllegalStateException();
            }
            EmbeddedSlotMap newMap = new EmbeddedSlotMap();
            owner.setMap(newMap);
            newMap.add(owner, this.slot);
            newMap.add(owner, newSlot);
        }

        @Override
        public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap compoundOp, Object key, int index, SlotMap.SlotComputer<S> c) {
            EmbeddedSlotMap newMap = new EmbeddedSlotMap();
            owner.setMap(newMap);
            newMap.add(owner, this.slot);
            return newMap.compute(owner, compoundOp, key, index, c);
        }
    }

    private static final class Iter
    implements Iterator<Slot> {
        private Slot next;

        Iter(Slot slot) {
            this.next = slot;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Slot next() {
            Slot ret = this.next;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.next = this.next.orderedNext;
            return ret;
        }
    }

    static final class ThreadedAccess {
        private static final VarHandle SLOT_MAP = ThreadedAccess.getSlotMapHandle();

        ThreadedAccess() {
        }

        private static VarHandle getSlotMapHandle() {
            try {
                return MethodHandles.lookup().findVarHandle(SlotMapOwner.class, "slotMap", SlotMap.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new Error(e);
            }
        }

        static SlotMap checkAndReplaceMap(SlotMapOwner owner, SlotMap oldMap, SlotMap newMap) {
            return SLOT_MAP.compareAndExchange(owner, oldMap, newMap);
        }
    }
}

