/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalConversionLoginModule
implements AuditLoginModule {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PRINCIPAL_CLASS_LIST = "principalClassList";
    private Subject subject;
    private String principalClazzList;
    private Principal principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.principalClazzList = (String)options.get(PRINCIPAL_CLASS_LIST);
    }

    @Override
    public boolean login() throws LoginException {
        logger.debug("login ok!");
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.subject == null || !this.subject.getPrincipals(UserPrincipal.class).isEmpty()) {
            return false;
        }
        if (this.principalClazzList != null) {
            String[] principalClasses;
            block0: for (String principalClass : principalClasses = this.principalClazzList.split(",")) {
                String trimmedCandidateClassName = principalClass.trim();
                for (Principal candidatePrincipal : this.subject.getPrincipals()) {
                    logger.debug("Checking principal class name:{}, {}", (Object)candidatePrincipal.getClass().getName(), (Object)candidatePrincipal);
                    if (!candidatePrincipal.getClass().getName().equals(trimmedCandidateClassName)) continue;
                    logger.debug("converting: {}", (Object)candidatePrincipal);
                    this.principal = new UserPrincipal(candidatePrincipal.getName());
                    this.subject.getPrincipals().add(this.principal);
                    continue block0;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("commit, result: {}", (Object)(this.principal != null ? 1 : 0));
        }
        return this.principal != null;
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(this.principal != null ? this.principal.getName() : null);
        this.clear();
        logger.debug("abort");
        return true;
    }

    private void clear() {
        this.principal = null;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject != null) {
            this.subject.getPrincipals().remove(this.principal);
        }
        this.clear();
        logger.debug("logout");
        return true;
    }
}

