/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JSCode;
import org.mozilla.javascript.JSScript;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptJSCode;

public abstract class OptJSScriptCode
extends OptJSCode<JSScript> {
    protected OptJSScriptCode() {
    }

    @Override
    public abstract Object execute(Context var1, JSScript var2, Object var3, Scriptable var4, Object var5, Object[] var6);

    @Override
    public abstract Object resume(Context var1, JSScript var2, Object var3, Scriptable var4, int var5, Object var6);

    public static class Builder
    extends OptJSCode.Builder<JSScript> {
        public Builder(OptJSCode.BuilderEnv env) {
            super(env);
        }

        @Override
        public JSCode<JSScript> build() {
            if (this.built != null) {
                return this.built;
            }
            try {
                String subClassName = this.getClassName();
                byte[] subClassBytes = this.getClassBytes();
                GeneratedClassLoader loader = (GeneratedClassLoader)((Object)this.env.compiledClass.getClassLoader());
                Class<?> subClass = loader.defineClass(subClassName, subClassBytes);
                loader.linkClass(subClass);
                OptJSScriptCode instance = (OptJSScriptCode)subClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.built = instance;
                return instance;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        String getClassName() {
            return this.env.className + "ojsc" + Integer.toString(this.index);
        }

        @Override
        byte[] getClassBytes() {
            return Codegen.generateOptJSCode(this.env.className, this.methodName, this.methodType, this.resumeName, this.resumeType, false, this.index);
        }
    }
}

