/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore.jcache;

import java.io.Closeable;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreException;
import org.apache.cxf.ws.security.utils.JCacheSupport;

public class JCacheTokenStore
implements TokenStore,
Closeable,
BusLifeCycleListener {
    private final Bus bus;
    private final Cache<String, SecurityToken> cache;
    private final CacheManager cacheManager;
    private final String key;

    public JCacheTokenStore(String key, Bus b, URL configFileURL) throws TokenStoreException {
        this.bus = b;
        if (this.bus != null) {
            ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }
        this.key = key;
        try {
            String template = key;
            if (template.contains("-")) {
                template = key.substring(0, key.lastIndexOf(45));
            }
            CachingProvider cachingProvider = Caching.getCachingProvider();
            this.cacheManager = cachingProvider.getCacheManager(configFileURL.toURI(), SecurityToken.class.getClassLoader());
            this.cache = JCacheSupport.getOrCreate(this.cacheManager, key, String.class, SecurityToken.class);
        }
        catch (Exception e) {
            throw new TokenStoreException(e);
        }
    }

    @Override
    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cache.put((Object)token.getId(), (Object)token);
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)identifier)) {
            this.cache.put((Object)identifier, (Object)token);
        }
    }

    @Override
    public void remove(String identifier) {
        if (this.cache != null && !StringUtils.isEmpty((String)identifier)) {
            this.cache.remove((Object)identifier);
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        if (this.cache == null) {
            return null;
        }
        HashSet<String> keys = new HashSet<String>();
        for (Cache.Entry entry : this.cache) {
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    @Override
    public SecurityToken getToken(String identifier) {
        if (this.cache == null) {
            return null;
        }
        return (SecurityToken)this.cache.get((Object)identifier);
    }

    @Override
    public synchronized void close() {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(this.key);
            this.cacheManager.close();
        }
        if (this.bus != null) {
            ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

