/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionDetail;

public class CoreTransactionDetail
extends TransactionDetail {
    public CoreTransactionDetail(Xid xid, Transaction tx, Long creation) {
        super(xid, tx, creation);
    }

    @Override
    public String decodeMessageType(Message msg) {
        if (!(msg instanceof ICoreMessage)) {
            return "N/A";
        }
        ICoreMessage coreMessage = (ICoreMessage)msg;
        return switch (coreMessage.getType()) {
            case 0 -> "Default";
            case 2 -> "ObjectMessage";
            case 3 -> "TextMessage";
            case 4 -> "ByteMessage";
            case 5 -> "MapMessage";
            case 6 -> "StreamMessage";
            default -> "(Unknown Type)";
        };
    }

    @Override
    public Map<String, Object> decodeMessageProperties(Message msg) {
        return msg.toMap(256);
    }
}

