/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.fiql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.AndSearchCondition;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.SimpleSearchCondition;

public class FiqlParser<T>
extends AbstractSearchConditionParser<T> {
    public static final String OR = ",";
    public static final String AND = ";";
    public static final String GT = "=gt=";
    public static final String GE = "=ge=";
    public static final String LT = "=lt=";
    public static final String LE = "=le=";
    public static final String EQ = "==";
    public static final String NEQ = "!=";
    public static final Map<ConditionType, String> CONDITION_MAP;
    public static final String SUPPORT_SINGLE_EQUALS = "fiql.support.single.equals.operator";
    public static final String EXTENSION_COUNT = "count";
    protected static final String EXTENSION_COUNT_OPEN = "count(";
    private static final Map<String, ConditionType> OPERATORS_MAP;
    private static final Pattern COMPARATORS_PATTERN;
    private static final Pattern COMPARATORS_PATTERN_SINGLE_EQUALS;
    protected Map<String, ConditionType> operatorsMap = OPERATORS_MAP;
    protected Pattern comparatorsPattern = COMPARATORS_PATTERN;

    public FiqlParser(Class<T> tclass) {
        this(tclass, Collections.emptyMap());
    }

    public FiqlParser(Class<T> tclass, Map<String, String> contextProperties) {
        this(tclass, contextProperties, null);
    }

    public FiqlParser(Class<T> tclass, Map<String, String> contextProperties, Map<String, String> beanProperties) {
        super(tclass, contextProperties, beanProperties);
        if (PropertyUtils.isTrue(this.contextProperties.get(SUPPORT_SINGLE_EQUALS))) {
            this.operatorsMap = new HashMap<String, ConditionType>(this.operatorsMap);
            this.operatorsMap.put("=", ConditionType.EQUALS);
            this.comparatorsPattern = COMPARATORS_PATTERN_SINGLE_EQUALS;
        }
    }

    @Override
    public SearchCondition<T> parse(String fiqlExpression) throws SearchParseException {
        ASTNode<T> ast = this.parseAndsOrsBrackets(fiqlExpression);
        return ast.build();
    }

    private ASTNode<T> parseAndsOrsBrackets(String expr) throws SearchParseException {
        ArrayList<String> subexpressions = new ArrayList<String>();
        ArrayList<String> operators = new ArrayList<String>();
        int level = 0;
        int lastIdx = 0;
        for (int idx = 0; idx < expr.length(); ++idx) {
            boolean isEnd;
            boolean isOperator;
            char c = expr.charAt(idx);
            if (c == '(') {
                ++level;
            } else if (c == ')' && --level < 0) {
                throw new SearchParseException(String.format("Unexpected closing bracket at position %d", idx));
            }
            String cs = Character.toString(c);
            boolean bl = isOperator = AND.equals(cs) || OR.equals(cs);
            if (level == 0 && isOperator) {
                String s1 = expr.substring(lastIdx, idx);
                String s2 = expr.substring(idx, idx + 1);
                subexpressions.add(s1);
                operators.add(s2);
                lastIdx = idx + 1;
            }
            boolean bl2 = isEnd = idx == expr.length() - 1;
            if (!isEnd) continue;
            String s1 = expr.substring(lastIdx, idx + 1);
            subexpressions.add(s1);
            operators.add(null);
            lastIdx = idx + 1;
        }
        if (level != 0) {
            throw new SearchParseException(String.format("Unmatched opening and closing brackets in expression: %s", expr));
        }
        if (operators.get(operators.size() - 1) != null) {
            String op = (String)operators.get(operators.size() - 1);
            String ex = (String)subexpressions.get(subexpressions.size() - 1);
            throw new SearchParseException("Dangling operator at the end of expression: ..." + ex + op);
        }
        int from = 0;
        int to = 0;
        SubExpression ors = new SubExpression(OR);
        while (to < operators.size()) {
            while (to < operators.size() && AND.equals(operators.get(to))) {
                ++to;
            }
            SubExpression ands = new SubExpression(AND);
            while (from <= to) {
                String subex = (String)subexpressions.get(from);
                ASTNode<T> node = subex.startsWith("(") ? this.parseAndsOrsBrackets(subex.substring(1, subex.length() - 1)) : this.parseComparison(subex);
                if (node != null) {
                    ands.add(node);
                }
                ++from;
            }
            to = from;
            if (ands.getSubnodes().size() == 1) {
                ors.add(ands.getSubnodes().get(0));
                continue;
            }
            ors.add(ands);
        }
        if (ors.getSubnodes().size() == 1) {
            return ors.getSubnodes().get(0);
        }
        return ors;
    }

    protected ASTNode<T> parseComparison(String expr) throws SearchParseException {
        Matcher m = this.comparatorsPattern.matcher(expr);
        if (m.find()) {
            String propertyName = expr.substring(0, m.start(1));
            String operator = m.group(1);
            String value = expr.substring(m.end(1));
            if ("".equals(value)) {
                throw new SearchParseException("Not a comparison expression: " + expr);
            }
            String name = this.unwrapSetter(propertyName);
            TypeInfoObject castedValue = this.parseType(propertyName, name = this.getActualSetterName(name), value);
            if (castedValue != null) {
                return new Comparison(name, operator, castedValue);
            }
            return null;
        }
        throw new SearchParseException("Not a comparison expression: " + expr);
    }

    protected TypeInfoObject parseType(String originalName, String setter, String value) throws SearchParseException {
        Beanspector.TypeInfo typeInfo = this.getTypeInfo(setter, value);
        if (this.isDecodeQueryValues().booleanValue()) {
            value = UrlUtils.urlDecode((String)value);
        }
        Object object = this.parseType(originalName, null, null, setter, typeInfo, value);
        return new TypeInfoObject(object, typeInfo);
    }

    @Override
    protected boolean isCount(String propName) {
        return propName.startsWith(EXTENSION_COUNT_OPEN);
    }

    protected String unwrapSetter(String setter) {
        if (setter.startsWith(EXTENSION_COUNT_OPEN) && setter.endsWith(")")) {
            return setter.substring(EXTENSION_COUNT_OPEN.length(), setter.length() - 1);
        }
        return setter;
    }

    static {
        OPERATORS_MAP = new HashMap<String, ConditionType>();
        OPERATORS_MAP.put(GT, ConditionType.GREATER_THAN);
        OPERATORS_MAP.put(GE, ConditionType.GREATER_OR_EQUALS);
        OPERATORS_MAP.put(LT, ConditionType.LESS_THAN);
        OPERATORS_MAP.put(LE, ConditionType.LESS_OR_EQUALS);
        OPERATORS_MAP.put(EQ, ConditionType.EQUALS);
        OPERATORS_MAP.put(NEQ, ConditionType.NOT_EQUALS);
        CONDITION_MAP = new EnumMap<ConditionType, String>(ConditionType.class);
        CONDITION_MAP.put(ConditionType.GREATER_THAN, GT);
        CONDITION_MAP.put(ConditionType.GREATER_OR_EQUALS, GE);
        CONDITION_MAP.put(ConditionType.LESS_THAN, LT);
        CONDITION_MAP.put(ConditionType.LESS_OR_EQUALS, LE);
        CONDITION_MAP.put(ConditionType.EQUALS, EQ);
        CONDITION_MAP.put(ConditionType.NOT_EQUALS, NEQ);
        String comparators = "=gt=|=ge=|=lt=|=le=|==|!=";
        String s1 = "[\\p{ASCII}]+(" + comparators + ")";
        COMPARATORS_PATTERN = Pattern.compile(s1);
        String s2 = "[\\p{ASCII}]+(" + comparators + "|=)";
        COMPARATORS_PATTERN_SINGLE_EQUALS = Pattern.compile(s2);
    }

    protected static interface ASTNode<T> {
        public SearchCondition<T> build() throws SearchParseException;
    }

    private class SubExpression
    implements ASTNode<T> {
        private final String operator;
        private final List<ASTNode<T>> subnodes = new ArrayList();

        SubExpression(String operator) {
            this.operator = operator;
        }

        public void add(ASTNode<T> node) {
            this.subnodes.add(node);
        }

        public List<ASTNode<T>> getSubnodes() {
            return Collections.unmodifiableList(this.subnodes);
        }

        public String toString() {
            String s = this.operator.equals(FiqlParser.AND) ? "AND" : "OR";
            StringBuilder builder = new StringBuilder(s);
            builder.append(":[");
            for (int i = 0; i < this.subnodes.size(); ++i) {
                builder.append(this.subnodes.get(i));
                if (i >= this.subnodes.size() - 1) continue;
                builder.append(", ");
            }
            builder.append(']');
            return builder.toString();
        }

        @Override
        public SearchCondition<T> build() throws SearchParseException {
            ArrayList scNodes = new ArrayList();
            for (ASTNode node : this.subnodes) {
                scNodes.add(node.build());
            }
            if (FiqlParser.OR.equals(this.operator)) {
                return new OrSearchCondition(scNodes);
            }
            return new AndSearchCondition(scNodes);
        }
    }

    protected static class TypeInfoObject {
        private final Object object;
        private final Beanspector.TypeInfo typeInfo;

        TypeInfoObject(Object object, Beanspector.TypeInfo typeInfo) {
            this.object = object;
            this.typeInfo = typeInfo;
        }

        public Beanspector.TypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        public Object getObject() {
            return this.object;
        }
    }

    private class Comparison
    implements ASTNode<T> {
        private final String name;
        private final String operator;
        private final TypeInfoObject tvalue;

        Comparison(String name, String operator, TypeInfoObject value) {
            this.name = name;
            this.operator = operator;
            this.tvalue = value;
        }

        public String toString() {
            return this.name + " " + this.operator + " " + String.valueOf(this.tvalue.getObject()) + " (" + this.tvalue.getObject().getClass().getSimpleName() + ")";
        }

        @Override
        public SearchCondition<T> build() throws SearchParseException {
            String templateName = FiqlParser.this.getSetter(this.name);
            Object cond = this.createTemplate(templateName);
            ConditionType ct = FiqlParser.this.operatorsMap.get(this.operator);
            if (this.isPrimitive(cond)) {
                return new SimpleSearchCondition(ct, cond);
            }
            String templateNameLCase = templateName.toLowerCase();
            return new SimpleSearchCondition(Collections.singletonMap(templateNameLCase, ct), Collections.singletonMap(templateNameLCase, this.name), Collections.singletonMap(templateNameLCase, this.tvalue.getTypeInfo()), cond);
        }

        private boolean isPrimitive(T pojo) {
            return pojo.getClass().getName().startsWith("java.lang");
        }

        private T createTemplate(String setter) throws SearchParseException {
            try {
                if (FiqlParser.this.beanspector != null) {
                    FiqlParser.this.beanspector.instantiate().setValue(setter, this.tvalue.getObject());
                    return FiqlParser.this.beanspector.getBean();
                }
                SearchBean bean = (SearchBean)FiqlParser.this.conditionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bean.set(setter, this.tvalue.getObject().toString());
                return bean;
            }
            catch (Throwable e) {
                throw new SearchParseException(e);
            }
        }
    }
}

