/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2ws;

import java.util.HashSet;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.JAXWSFrontEndProcessor;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.SimpleFrontEndProcessor;

public class JavaToWSContainer
extends AbstractCXFToolContainer {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSContainer.class);
    private static final String TOOL_NAME = "java2ws";

    public JavaToWSContainer(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    public void execute(boolean exitOnFinish) throws ToolException {
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                String ft;
                ToolContext env = new ToolContext();
                env.setParameters(this.getParametersMap(new HashSet()));
                if (this.getContext() != null && this.getContext().get("compiler") != null) {
                    env.put("compiler", this.getContext().get("compiler"));
                }
                if (env.get("outputdir") == null) {
                    env.put("outputdir", (Object)".");
                }
                if (env.get("sourcedir") == null) {
                    env.put("sourcedir", (Object)".");
                }
                if (this.isVerboseOn()) {
                    env.put("verbose", (Object)Boolean.TRUE);
                }
                if ((ft = (String)env.get("frontend")) == null || "jaxws".equals(ft)) {
                    ft = "jaxws";
                } else {
                    ft = "simple";
                    env.put("databinding", (Object)"aegis");
                }
                env.put("frontend", (Object)ft);
                this.processWSDL(env, ft);
            }
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
                if (this.isVerboseOn()) {
                    ex.printStackTrace(this.err);
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            Throwable e = ex;
            while ((e.getMessage() == null || "".equals(e.getMessage())) && e.getCause() != null) {
                e = e.getCause();
            }
            this.err.println("Error: " + e.toString());
            this.err.println();
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            } else {
                this.err.println("Use the verbose setting to show the stacktrace of this error");
            }
            throw new ToolException(ex.getMessage(), ex.getCause());
        }
        finally {
            this.tearDown();
        }
    }

    private void processWSDL(ToolContext env, String ft) {
        Object processor = new JavaToWSDLProcessor();
        processor.setEnvironment(env);
        processor.process();
        if (ft.equals("jaxws")) {
            if (env.optionSet("server") || env.optionSet("client")) {
                processor = new JAXWSFrontEndProcessor();
                processor.setEnvironment(env);
                processor.process();
            }
        } else {
            processor = new SimpleFrontEndProcessor();
            processor.setEnvironment(env);
            processor.process();
        }
    }

    public void checkParams(ErrorVisitor errs) throws ToolException {
        Message msg;
        String ft;
        super.checkParams(errs);
        CommandDocument doc = super.getCommandDocument();
        if (doc.hasParameter("frontend")) {
            ft = doc.getParameter("frontend");
            if (!"jaxws".equals(ft) && !"simple".equals(ft)) {
                msg = new Message("INVALID_FRONTEND", LOG, new Object[]{ft});
                errs.add((CommandLineError)new ErrorVisitor.UserError(msg.toString()));
            }
            if ("simple".equals(ft) && doc.getParameter("databinding") != null && !"aegis".equals(doc.getParameter("databinding"))) {
                msg = new Message("INVALID_DATABINDING_FOR_SIMPLE", LOG, new Object[0]);
                errs.add((CommandLineError)new ErrorVisitor.UserError(msg.toString()));
            }
        }
        if (doc.hasParameter("wrapperbean") && (ft = doc.getParameter("frontend")) != null && !"jaxws".equals(ft)) {
            msg = new Message("WRAPPERBEAN_WITHOUT_JAXWS", LOG, new Object[0]);
            errs.add((CommandLineError)new ErrorVisitor.UserError(msg.toString()));
        }
        if (errs.getErrors().size() > 0) {
            Message msg2 = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg2, (Throwable)new BadUsageException(this.getUsage(), errs));
        }
    }
}

