/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.CartesianProductIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CartesianProductIteratorTest
extends AbstractIteratorTest<List<Character>> {
    private List<Character> letters;
    private List<Character> numbers;
    private List<Character> symbols;
    private List<Character> emptyList;

    @Override
    public CartesianProductIterator<Character> makeEmptyIterator() {
        return new CartesianProductIterator(new Iterable[0]);
    }

    @Override
    public CartesianProductIterator<Character> makeObject() {
        return new CartesianProductIterator(new Iterable[]{this.letters, this.numbers, this.symbols});
    }

    @BeforeEach
    public void setUp() {
        this.letters = Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'));
        this.numbers = Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'));
        this.symbols = Arrays.asList(Character.valueOf('!'), Character.valueOf('?'));
        this.emptyList = Collections.emptyList();
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testEmptyCollection() {
        CartesianProductIterator it = new CartesianProductIterator(new Iterable[]{this.letters, Collections.emptyList()});
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CartesianProductIterator)it).next());
    }

    @Test
    public void testExhaustivity() {
        ArrayList<Character[]> resultsList = new ArrayList<Character[]>();
        CartesianProductIterator<Character> it = this.makeObject();
        while (it.hasNext()) {
            List tuple = it.next();
            resultsList.add(tuple.toArray(new Character[0]));
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next());
        Assertions.assertEquals((int)18, (int)resultsList.size());
        Iterator itResults = resultsList.iterator();
        for (Character a : this.letters) {
            for (Character b : this.numbers) {
                for (Character c : this.symbols) {
                    Assertions.assertArrayEquals((Object[])new Character[]{a, b, c}, (Object[])((Object[])itResults.next()));
                }
            }
        }
    }

    @Test
    public void testExhaustivityWithAllEmptyLists() {
        ArrayList<Character[]> resultsList = new ArrayList<Character[]>();
        CartesianProductIterator it = new CartesianProductIterator(new Iterable[]{this.emptyList, this.emptyList, this.emptyList});
        while (it.hasNext()) {
            List tuple = it.next();
            resultsList.add(tuple.toArray(new Character[0]));
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CartesianProductIterator)it).next());
        Assertions.assertEquals((int)0, (int)resultsList.size());
    }

    @Test
    public void testExhaustivityWithEmptyFirstList() {
        ArrayList<Character[]> resultsList = new ArrayList<Character[]>();
        CartesianProductIterator it = new CartesianProductIterator(new Iterable[]{this.emptyList, this.numbers, this.symbols});
        while (it.hasNext()) {
            List tuple = it.next();
            resultsList.add(tuple.toArray(new Character[0]));
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CartesianProductIterator)it).next());
        Assertions.assertEquals((int)0, (int)resultsList.size());
    }

    @Test
    public void testExhaustivityWithEmptyLastList() {
        ArrayList<Character[]> resultsList = new ArrayList<Character[]>();
        CartesianProductIterator it = new CartesianProductIterator(new Iterable[]{this.letters, this.numbers, this.emptyList});
        while (it.hasNext()) {
            List tuple = it.next();
            resultsList.add(tuple.toArray(new Character[0]));
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CartesianProductIterator)it).next());
        Assertions.assertEquals((int)0, (int)resultsList.size());
    }

    @Test
    public void testExhaustivityWithEmptyList() {
        ArrayList<Character[]> resultsList = new ArrayList<Character[]>();
        CartesianProductIterator it = new CartesianProductIterator(new Iterable[]{this.letters, this.emptyList, this.symbols});
        while (it.hasNext()) {
            List tuple = it.next();
            resultsList.add(tuple.toArray(new Character[0]));
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CartesianProductIterator)it).next());
        Assertions.assertEquals((int)0, (int)resultsList.size());
    }

    @Test
    public void testExhaustivityWithSameList() {
        ArrayList<Character[]> resultsList = new ArrayList<Character[]>();
        CartesianProductIterator it = new CartesianProductIterator(new Iterable[]{this.letters, this.letters, this.letters});
        while (it.hasNext()) {
            List tuple = it.next();
            resultsList.add(tuple.toArray(new Character[0]));
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CartesianProductIterator)it).next());
        Assertions.assertEquals((int)27, (int)resultsList.size());
        Iterator itResults = resultsList.iterator();
        for (Character a : this.letters) {
            for (Character b : this.letters) {
                for (Character c : this.letters) {
                    Assertions.assertArrayEquals((Object[])new Character[]{a, b, c}, (Object[])((Object[])itResults.next()));
                }
            }
        }
    }

    @Override
    @Test
    public void testForEachRemaining() {
        ArrayList resultsList = new ArrayList();
        CartesianProductIterator<Character> it = this.makeObject();
        it.forEachRemaining(tuple -> resultsList.add(tuple.toArray(new Character[0])));
        Assertions.assertEquals((int)18, (int)resultsList.size());
        Iterator itResults = resultsList.iterator();
        for (Character a : this.letters) {
            for (Character b : this.numbers) {
                for (Character c : this.symbols) {
                    Assertions.assertArrayEquals((Object[])new Character[]{a, b, c}, (Object[])((Object[])itResults.next()));
                }
            }
        }
    }

    @Test
    public void testRemoveThrows() {
        CartesianProductIterator<Character> it = this.makeObject();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove());
    }
}

