/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriterContext;
import org.apache.celeborn.service.deploy.worker.storage.PartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.celeborn.service.deploy.worker.storage.TierWriterBase;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\f\u0019\u0001\u001dB\u0011\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u001a\t\u0013Q\u0002!\u0011!Q\u0001\nUB\u0004\"C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001eG\u0011%A\u0005A!A!\u0002\u0013IE\nC\u0005N\u0001\t\u0005\t\u0015!\u0003O+\"Ia\u000b\u0001B\u0001B\u0003%q+\u0018\u0005\n=\u0002\u0011\t\u0011)A\u0005?&D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\n]\u0002\u0011\t\u0011)A\u0005_JDQa\u001d\u0001\u0005\u0002QD\u0001b \u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\u0004!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\tY\u0004\u0001C!\u0003{Aq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u007f\u0002A\u0011IA-\u0005AiU-\\8ssRKWM],sSR,'O\u0003\u0002\u001a5\u000591\u000f^8sC\u001e,'BA\u000e\u001d\u0003\u00199xN]6fe*\u0011QDH\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005}\u0001\u0013aB:feZL7-\u001a\u0006\u0003C\t\n\u0001bY3mK\n|'O\u001c\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015+\u001b\u0005A\u0012BA\u0016\u0019\u00059!\u0016.\u001a:Xe&$XM\u001d\"bg\u0016\fAaY8oMB\u0011a&M\u0007\u0002_)\u0011\u0001\u0007I\u0001\u0007G>lWn\u001c8\n\u0005Iz#\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017B\u0001\u0017+\u0003-iW\r^1IC:$G.\u001a:\u0011\u0005%2\u0014BA\u001c\u0019\u0005Q\u0001\u0016M\u001d;ji&|g.T3uC\"\u000bg\u000e\u001a7fe&\u0011AGK\u0001\u0012]Vl\u0007+\u001a8eS:<wK]5uKJ\u001c\bCA\u001eE\u001b\u0005a$BA\u001f?\u0003\u0019\tGo\\7jG*\u0011q\bQ\u0001\u000bG>t7-\u001e:sK:$(BA!C\u0003\u0011)H/\u001b7\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0010\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\n\u0005\u001dS\u0013\u0001\u00058v[B+g\u000eZ5oO^\u0013\u0018\u000e^3t\u0003!qw\u000e^5gS\u0016\u0014\bCA\u0015K\u0013\tY\u0005DA\u0007GYV\u001c\bNT8uS\u001aLWM]\u0005\u0003\u0011*\naa]8ve\u000e,\u0007CA(T\u001b\u0005\u0001&BA'R\u0015\t\u0011v&A\u0004nKR\u0014\u0018nY:\n\u0005Q\u0003&AD!cgR\u0014\u0018m\u0019;T_V\u00148-Z\u0005\u0003\u001b*\n\u0001BZ5mK&sgm\u001c\t\u00031nk\u0011!\u0017\u0006\u00035>\nA!\\3uC&\u0011A,\u0017\u0002\u000f\u001b\u0016lwN]=GS2,\u0017J\u001c4p\u0013\t1&&A\u0006ti>\u0014\u0018mZ3UsB,\u0007C\u00011g\u001d\t\tG-D\u0001c\u0015\t\u0019w&\u0001\u0005qe>$xnY8m\u0013\t)'-A\u0006Ti>\u0014\u0018mZ3J]\u001a|\u0017BA4i\u0005\u0011!\u0016\u0010]3\u000b\u0005\u0015\u0014\u0017B\u00010+\u0003i\u0001\u0018M\u001d;ji&|g\u000eR1uC^\u0013\u0018\u000e^3s\u0007>tG/\u001a=u!\tIC.\u0003\u0002n1\tQ\u0002+\u0019:uSRLwN\u001c#bi\u0006<&/\u001b;fe\u000e{g\u000e^3yi\u0006q1\u000f^8sC\u001e,W*\u00198bO\u0016\u0014\bCA\u0015q\u0013\t\t\bD\u0001\bTi>\u0014\u0018mZ3NC:\fw-\u001a:\n\u00059T\u0013A\u0002\u001fj]&$h\b\u0006\u0006vm^D\u0018P_>}{z\u0004\"!\u000b\u0001\t\u000b1R\u0001\u0019A\u0017\t\u000bQR\u0001\u0019A\u001b\t\u000beR\u0001\u0019\u0001\u001e\t\u000b!S\u0001\u0019A%\t\u000b5S\u0001\u0019\u0001(\t\u000bYS\u0001\u0019A,\t\u000byS\u0001\u0019A0\t\u000b)T\u0001\u0019A6\t\u000b9T\u0001\u0019A8\u000295,Wn\u001c:z\r&dWm\u0015;pe\u0006<W-T1y\r&dWmU5{KV\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0011\u0011\u0011B\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u001b\t9A\u0001\u0003M_:<\u0017!H7f[>\u0014\u0018PR5mKN#xN]1hK6\u000b\u0007PR5mKNK'0\u001a\u0011\u0002\u00139,W\rZ#wS\u000e$HCAA\u000b!\u0011\t)!a\u0006\n\t\u0005e\u0011q\u0001\u0002\b\u0005>|G.Z1o\u0003\u0015)g/[2u)\u0011\ty\"!\n\u0011\t\u0005\u0015\u0011\u0011E\u0005\u0005\u0003G\t9A\u0001\u0003V]&$\bBBA\u0014\u001d\u0001\u0007\u0001&\u0001\u0003gS2,\u0017\u0001D4f]\u001acWo\u001d5UCN\\GCBA\u0017\u0003g\t9\u0004E\u0002*\u0003_I1!!\r\u0019\u0005%1E.^:i)\u0006\u001c8\u000eC\u0004\u00026=\u0001\r!!\u0006\u0002\u0015\u0019Lg.\u00197GYV\u001c\b\u000eC\u0004\u0002:=\u0001\r!!\u0006\u0002\u0015-,W\r\u001d\"vM\u001a,'/A\u0007xe&$X-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003?\ty\u0004C\u0004\u0002BA\u0001\r!a\u0011\u0002\u0007\t,h\r\u0005\u0003\u0002F\u0005MSBAA$\u0015\u0011\tI%a\u0013\u0002\r\t,hMZ3s\u0015\u0011\ti%a\u0014\u0002\u000b9,G\u000f^=\u000b\u0005\u0005E\u0013AA5p\u0013\u0011\t)&a\u0012\u0003\u000f\tKH/\u001a\"vM\u0006a1\r\\8tKN#(/Z1ngR\u0011\u0011qD\u0001\u0013i\u0006\\WMQ;gM\u0016\u0014\u0018J\u001c;fe:\fG\u000e\u0006\u0002\u0002`A!\u0011QIA1\u0013\u0011\t\u0019'a\u0012\u0003!\r{W\u000e]8tSR,')\u001f;f\u0005V4\u0017\u0001\u0006:fiV\u0014hNQ;gM\u0016\u0014\u0018J\u001c;fe:\fG\u000e\u0006\u0003\u0002 \u0005%\u0004bBA6'\u0001\u0007\u0011QC\u0001\bI\u0016\u001cHO]8z\u00031\tG\r\u001a$mkNDG+Y:l)\u0011\ty\"!\u001d\t\u000f\u0005MD\u00031\u0001\u0002.\u0005!A/Y:l\u0003)9W\r\u001e$mkNDWM\u001d\u000b\u0003\u0003s\u00022!KA>\u0013\r\ti\b\u0007\u0002\b\r2,8\u000f[3s\u0003=A\u0017M\u001c3mK\u0016C8-\u001a9uS>t\u0007")
public class MemoryTierWriter
extends TierWriterBase {
    private final long memoryFileStorageMaxFileSize;

    public long memoryFileStorageMaxFileSize() {
        return this.memoryFileStorageMaxFileSize;
    }

    @Override
    public boolean needEvict() {
        return (long)this.flushBuffer().readableBytes() > this.memoryFileStorageMaxFileSize() && super.storageManager().localOrDfsStorageAvailable();
    }

    @Override
    public void evict(TierWriterBase file) {
        Object object = this.flushLock();
        synchronized (object) {
            file.swapFlushBuffer(this.flushBuffer());
            file.flush(false, true);
            int numBytes = this.flushBuffer().readableBytes();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Evict ").append(numBytes).append(" from memory to other tier").toString());
            MemoryManager.instance().releaseMemoryFileStorage(numBytes);
            MemoryManager.instance().incrementDiskBuffer(numBytes);
            super.storageManager().unregisterMemoryPartitionWriterAndFileInfo((MemoryFileInfo)super.fileInfo(), this.shuffleKey(), this.filename());
            super.storageManager().evictedFileCount().incrementAndGet();
        }
    }

    @Override
    public FlushTask genFlushTask(boolean finalFlush, boolean keepBuffer) {
        return null;
    }

    @Override
    public void writeInternal(ByteBuf buf) {
        buf.retain();
        int numBytes = buf.readableBytes();
        try {
            this.flushBuffer().addComponent(true, buf);
        }
        catch (OutOfMemoryError oom) {
            super.metaHandler().afterFlush(numBytes);
            MemoryManager.instance().incrementMemoryFileStorage(numBytes);
            throw oom;
        }
        super.metaHandler().afterFlush(numBytes);
        MemoryManager.instance().incrementMemoryFileStorage(numBytes);
    }

    @Override
    public void closeStreams() {
        this.flushBuffer().consolidate();
        ((MemoryFileInfo)super.fileInfo()).setBuffer(this.flushBuffer());
    }

    @Override
    public CompositeByteBuf takeBufferInternal() {
        return super.storageManager().storageBufferAllocator().compositeBuffer(Integer.MAX_VALUE);
    }

    @Override
    public void returnBufferInternal(boolean destroy) {
        if (destroy && this.flushBuffer() != null) {
            this.flushBuffer().removeComponents(0, this.flushBuffer().numComponents());
            this.flushBuffer().release();
            return;
        }
    }

    @Override
    public void addFlushTask(FlushTask task) {
    }

    @Override
    public Flusher getFlusher() {
        return null;
    }

    @Override
    public void handleException() {
    }

    public MemoryTierWriter(CelebornConf conf, PartitionMetaHandler metaHandler, AtomicInteger numPendingWriters, FlushNotifier notifier, AbstractSource source, MemoryFileInfo fileInfo, StorageInfo.Type storageType, PartitionDataWriterContext partitionDataWriterContext, StorageManager storageManager) {
        super(conf, metaHandler, numPendingWriters, notifier, (FileInfo)fileInfo, source, storageType, partitionDataWriterContext.getPartitionLocation().getFileName(), partitionDataWriterContext.getShuffleKey(), storageManager);
        StorageInfo.Type type = super.storageType();
        StorageInfo.Type type2 = StorageInfo.Type.MEMORY;
        Predef$.MODULE$.assert(!(type != null ? !type.equals(type2) : type2 != null));
        this.memoryFileStorageMaxFileSize = super.conf().workerMemoryFileStorageMaxFileSize();
        super.storageManager().registerMemoryPartitionWriter(partitionDataWriterContext.getPartitionDataWriter(), (MemoryFileInfo)super.fileInfo());
    }
}

