/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.context;

import java.util.Objects;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.merge.context.EntityMergeSupport;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.ModelMergeDelegate;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.validation.ValidationResult;

public class MergerContext {
    private DataMap dataMap;
    private DataNode dataNode;
    private ValidationResult validationResult;
    private ModelMergeDelegate delegate;
    private EntityMergeSupport entityMergeSupport;
    private ObjectNameGenerator nameGenerator;

    protected MergerContext() {
    }

    public static Builder builder(DataMap dataMap) {
        return new Builder(dataMap);
    }

    public EntityMergeSupport getEntityMergeSupport() {
        return this.entityMergeSupport;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public DataNode getDataNode() {
        return this.dataNode;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public ModelMergeDelegate getDelegate() {
        return this.delegate;
    }

    public ObjectNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public static class Builder {
        private MergerContext context = new MergerContext();
        private boolean usingPrimitives;
        private boolean usingJava7Types;
        private NameFilter meaningfulPKsFilter;

        private Builder(DataMap dataMap) {
            this.context.dataMap = Objects.requireNonNull(dataMap);
            this.context.validationResult = new ValidationResult();
        }

        public MergerContext build() {
            if (this.context.delegate == null) {
                this.delegate(new DefaultModelMergeDelegate());
            }
            if (this.context.dataNode == null) {
                this.dataNode(new DataNode());
            }
            if (this.context.nameGenerator == null) {
                this.context.nameGenerator = new DefaultObjectNameGenerator(NoStemStemmer.getInstance());
            }
            if (this.meaningfulPKsFilter == null) {
                this.meaningfulPKsFilter = NamePatternMatcher.EXCLUDE_ALL;
            }
            this.context.entityMergeSupport = new EntityMergeSupport(this.context.nameGenerator, this.meaningfulPKsFilter, true, this.usingPrimitives, this.usingJava7Types);
            return this.context;
        }

        public Builder delegate(ModelMergeDelegate delegate) {
            this.context.delegate = Objects.requireNonNull(delegate);
            return this;
        }

        public Builder nameGenerator(ObjectNameGenerator nameGenerator) {
            this.context.nameGenerator = Objects.requireNonNull(nameGenerator);
            return this;
        }

        public Builder usingPrimitives(boolean flag) {
            this.usingPrimitives = flag;
            return this;
        }

        public Builder usingJava7Types(boolean flag) {
            this.usingJava7Types = flag;
            return this;
        }

        public Builder dataNode(DataNode dataNode) {
            this.context.dataNode = Objects.requireNonNull(dataNode);
            return this;
        }

        public Builder meaningfulPKFilter(NameFilter filter) {
            this.meaningfulPKsFilter = Objects.requireNonNull(filter);
            return this;
        }

        public Builder syntheticDataNode(DataSource dataSource, DbAdapter adapter) {
            DataNode dataNode = new DataNode();
            dataNode.setDataSource(dataSource);
            dataNode.setAdapter(adapter);
            return this.dataNode(dataNode);
        }
    }
}

