/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Frame;
import com.datastax.driver.core.FrameCompressor;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LZ4Compressor
extends FrameCompressor {
    private static final Logger logger;
    static final LZ4Compressor instance;
    private static final int INTEGER_BYTES = 4;
    private final net.jpountz.lz4.LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;

    private LZ4Compressor() {
        LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
        logger.info("Using {}", (Object)lz4Factory.toString());
        this.compressor = lz4Factory.fastCompressor();
        this.decompressor = lz4Factory.fastDecompressor();
    }

    @Override
    Frame compress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = this.compress(input, true);
        return frame.with(frameBody);
    }

    @Override
    ByteBuf compress(ByteBuf buffer) throws IOException {
        return this.compress(buffer, false);
    }

    private ByteBuf compress(ByteBuf buffer, boolean prependWithUncompressedLength) throws IOException {
        return buffer.isDirect() ? this.compressDirect(buffer, prependWithUncompressedLength) : this.compressHeap(buffer, prependWithUncompressedLength);
    }

    private ByteBuf compressDirect(ByteBuf input, boolean prependWithUncompressedLength) throws IOException {
        int maxCompressedLength = this.compressor.maxCompressedLength(input.readableBytes());
        ByteBuf output = input.alloc().directBuffer((prependWithUncompressedLength ? 4 : 0) + maxCompressedLength);
        try {
            ByteBuffer in = LZ4Compressor.inputNioBuffer(input);
            input.readerIndex(input.writerIndex());
            if (prependWithUncompressedLength) {
                output.writeInt(in.remaining());
            }
            ByteBuffer out = LZ4Compressor.outputNioBuffer(output);
            int written = this.compressor.compress(in, in.position(), in.remaining(), out, out.position(), out.remaining());
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    private ByteBuf compressHeap(ByteBuf input, boolean prependWithUncompressedLength) throws IOException {
        int maxCompressedLength = this.compressor.maxCompressedLength(input.readableBytes());
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer((prependWithUncompressedLength ? 4 : 0) + maxCompressedLength);
        try {
            if (prependWithUncompressedLength) {
                output.writeInt(len);
            }
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = this.compressor.compress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    @Override
    Frame decompress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        int uncompressedLength = input.readInt();
        ByteBuf frameBody = this.decompress(input, uncompressedLength);
        return frame.with(frameBody);
    }

    @Override
    ByteBuf decompress(ByteBuf buffer, int uncompressedLength) throws IOException {
        return buffer.isDirect() ? this.decompressDirect(buffer, uncompressedLength) : this.decompressHeap(buffer, uncompressedLength);
    }

    private ByteBuf decompressDirect(ByteBuf input, int uncompressedLength) throws IOException {
        int readable = input.readableBytes();
        ByteBuffer in = LZ4Compressor.inputNioBuffer(input);
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().directBuffer(uncompressedLength);
        try {
            ByteBuffer out = LZ4Compressor.outputNioBuffer(output);
            int read = this.decompressor.decompress(in, in.position(), out, out.position(), out.remaining());
            if (read != readable) {
                throw new IOException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    private ByteBuf decompressHeap(ByteBuf input, int uncompressedLength) throws IOException {
        byte[] in = input.array();
        int len = input.readableBytes();
        int inOffset = input.arrayOffset() + input.readerIndex();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(uncompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int read = this.decompressor.decompress(in, inOffset, out, offset, uncompressedLength);
            if (read != len) {
                throw new IOException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    static {
        LZ4Compressor i;
        logger = LoggerFactory.getLogger(LZ4Compressor.class);
        try {
            i = new LZ4Compressor();
        }
        catch (NoClassDefFoundError e) {
            i = null;
            logger.warn("Cannot find LZ4 class, you should make sure the LZ4 library is in the classpath if you intend to use it. LZ4 compression will not be available for the protocol.");
        }
        catch (Throwable e) {
            i = null;
            logger.warn("Error loading LZ4 library ({}). LZ4 compression will not be available for the protocol.", (Object)e.toString());
        }
        instance = i;
    }
}

