/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	json "encoding/json"
)

// JSONSchemaPropApplyConfiguration represents an declarative configuration of the JSONSchemaProp type for use
// with apply.
type JSONSchemaPropApplyConfiguration struct {
	ID               *string                  `json:"id,omitempty"`
	Deprecated       *bool                    `json:"deprecated,omitempty"`
	Description      *string                  `json:"description,omitempty"`
	Type             *string                  `json:"type,omitempty"`
	Format           *string                  `json:"format,omitempty"`
	Title            *string                  `json:"title,omitempty"`
	Default          *JSONApplyConfiguration  `json:"default,omitempty"`
	Maximum          *json.Number             `json:"maximum,omitempty"`
	ExclusiveMaximum *bool                    `json:"exclusiveMaximum,omitempty"`
	Minimum          *json.Number             `json:"minimum,omitempty"`
	ExclusiveMinimum *bool                    `json:"exclusiveMinimum,omitempty"`
	MaxLength        *int64                   `json:"maxLength,omitempty"`
	MinLength        *int64                   `json:"minLength,omitempty"`
	Pattern          *string                  `json:"pattern,omitempty"`
	MaxItems         *int64                   `json:"maxItems,omitempty"`
	MinItems         *int64                   `json:"minItems,omitempty"`
	UniqueItems      *bool                    `json:"uniqueItems,omitempty"`
	MaxProperties    *int64                   `json:"maxProperties,omitempty"`
	MinProperties    *int64                   `json:"minProperties,omitempty"`
	MultipleOf       *json.Number             `json:"multipleOf,omitempty"`
	Enum             []JSONApplyConfiguration `json:"enum,omitempty"`
	Example          *JSONApplyConfiguration  `json:"example,omitempty"`
	Nullable         *bool                    `json:"nullable,omitempty"`
	XDescriptors     []string                 `json:"x-descriptors,omitempty"`
}

// JSONSchemaPropApplyConfiguration constructs an declarative configuration of the JSONSchemaProp type for use with
// apply.
func JSONSchemaProp() *JSONSchemaPropApplyConfiguration {
	return &JSONSchemaPropApplyConfiguration{}
}

// WithID sets the ID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ID field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithID(value string) *JSONSchemaPropApplyConfiguration {
	b.ID = &value
	return b
}

// WithDeprecated sets the Deprecated field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Deprecated field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithDeprecated(value bool) *JSONSchemaPropApplyConfiguration {
	b.Deprecated = &value
	return b
}

// WithDescription sets the Description field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Description field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithDescription(value string) *JSONSchemaPropApplyConfiguration {
	b.Description = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithType(value string) *JSONSchemaPropApplyConfiguration {
	b.Type = &value
	return b
}

// WithFormat sets the Format field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Format field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithFormat(value string) *JSONSchemaPropApplyConfiguration {
	b.Format = &value
	return b
}

// WithTitle sets the Title field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Title field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithTitle(value string) *JSONSchemaPropApplyConfiguration {
	b.Title = &value
	return b
}

// WithDefault sets the Default field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Default field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithDefault(value *JSONApplyConfiguration) *JSONSchemaPropApplyConfiguration {
	b.Default = value
	return b
}

// WithMaximum sets the Maximum field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Maximum field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMaximum(value json.Number) *JSONSchemaPropApplyConfiguration {
	b.Maximum = &value
	return b
}

// WithExclusiveMaximum sets the ExclusiveMaximum field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExclusiveMaximum field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithExclusiveMaximum(value bool) *JSONSchemaPropApplyConfiguration {
	b.ExclusiveMaximum = &value
	return b
}

// WithMinimum sets the Minimum field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Minimum field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMinimum(value json.Number) *JSONSchemaPropApplyConfiguration {
	b.Minimum = &value
	return b
}

// WithExclusiveMinimum sets the ExclusiveMinimum field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExclusiveMinimum field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithExclusiveMinimum(value bool) *JSONSchemaPropApplyConfiguration {
	b.ExclusiveMinimum = &value
	return b
}

// WithMaxLength sets the MaxLength field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxLength field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMaxLength(value int64) *JSONSchemaPropApplyConfiguration {
	b.MaxLength = &value
	return b
}

// WithMinLength sets the MinLength field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinLength field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMinLength(value int64) *JSONSchemaPropApplyConfiguration {
	b.MinLength = &value
	return b
}

// WithPattern sets the Pattern field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Pattern field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithPattern(value string) *JSONSchemaPropApplyConfiguration {
	b.Pattern = &value
	return b
}

// WithMaxItems sets the MaxItems field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxItems field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMaxItems(value int64) *JSONSchemaPropApplyConfiguration {
	b.MaxItems = &value
	return b
}

// WithMinItems sets the MinItems field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinItems field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMinItems(value int64) *JSONSchemaPropApplyConfiguration {
	b.MinItems = &value
	return b
}

// WithUniqueItems sets the UniqueItems field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UniqueItems field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithUniqueItems(value bool) *JSONSchemaPropApplyConfiguration {
	b.UniqueItems = &value
	return b
}

// WithMaxProperties sets the MaxProperties field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxProperties field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMaxProperties(value int64) *JSONSchemaPropApplyConfiguration {
	b.MaxProperties = &value
	return b
}

// WithMinProperties sets the MinProperties field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinProperties field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMinProperties(value int64) *JSONSchemaPropApplyConfiguration {
	b.MinProperties = &value
	return b
}

// WithMultipleOf sets the MultipleOf field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MultipleOf field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithMultipleOf(value json.Number) *JSONSchemaPropApplyConfiguration {
	b.MultipleOf = &value
	return b
}

// WithEnum adds the given value to the Enum field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Enum field.
func (b *JSONSchemaPropApplyConfiguration) WithEnum(values ...*JSONApplyConfiguration) *JSONSchemaPropApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithEnum")
		}
		b.Enum = append(b.Enum, *values[i])
	}
	return b
}

// WithExample sets the Example field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Example field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithExample(value *JSONApplyConfiguration) *JSONSchemaPropApplyConfiguration {
	b.Example = value
	return b
}

// WithNullable sets the Nullable field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Nullable field is set to the value of the last call.
func (b *JSONSchemaPropApplyConfiguration) WithNullable(value bool) *JSONSchemaPropApplyConfiguration {
	b.Nullable = &value
	return b
}

// WithXDescriptors adds the given value to the XDescriptors field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the XDescriptors field.
func (b *JSONSchemaPropApplyConfiguration) WithXDescriptors(values ...string) *JSONSchemaPropApplyConfiguration {
	for i := range values {
		b.XDescriptors = append(b.XDescriptors, values[i])
	}
	return b
}
