/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// DataSpecApplyConfiguration represents an declarative configuration of the DataSpec type for use
// with apply.
type DataSpecApplyConfiguration struct {
	Name        *string `json:"name,omitempty"`
	Path        *string `json:"path,omitempty"`
	Content     *string `json:"content,omitempty"`
	RawContent  []byte  `json:"rawContent,omitempty"`
	ContentRef  *string `json:"contentRef,omitempty"`
	ContentKey  *string `json:"contentKey,omitempty"`
	ContentType *string `json:"contentType,omitempty"`
	Compression *bool   `json:"compression,omitempty"`
}

// DataSpecApplyConfiguration constructs an declarative configuration of the DataSpec type for use with
// apply.
func DataSpec() *DataSpecApplyConfiguration {
	return &DataSpecApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithName(value string) *DataSpecApplyConfiguration {
	b.Name = &value
	return b
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithPath(value string) *DataSpecApplyConfiguration {
	b.Path = &value
	return b
}

// WithContent sets the Content field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Content field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithContent(value string) *DataSpecApplyConfiguration {
	b.Content = &value
	return b
}

// WithRawContent adds the given value to the RawContent field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RawContent field.
func (b *DataSpecApplyConfiguration) WithRawContent(values ...byte) *DataSpecApplyConfiguration {
	for i := range values {
		b.RawContent = append(b.RawContent, values[i])
	}
	return b
}

// WithContentRef sets the ContentRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContentRef field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithContentRef(value string) *DataSpecApplyConfiguration {
	b.ContentRef = &value
	return b
}

// WithContentKey sets the ContentKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContentKey field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithContentKey(value string) *DataSpecApplyConfiguration {
	b.ContentKey = &value
	return b
}

// WithContentType sets the ContentType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContentType field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithContentType(value string) *DataSpecApplyConfiguration {
	b.ContentType = &value
	return b
}

// WithCompression sets the Compression field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Compression field is set to the value of the last call.
func (b *DataSpecApplyConfiguration) WithCompression(value bool) *DataSpecApplyConfiguration {
	b.Compression = &value
	return b
}
