/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Manage and interact with AWS Security Hub for security findings.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SecurityHubEndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Security Hub component.
     */
    public interface SecurityHubEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSecurityHubEndpointBuilder advanced() {
            return (AdvancedSecurityHubEndpointBuilder) this;
        }

        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.securityhub.SecurityHubOperations</code> type.
         * 
         * Required: true
         * Default: batchImportFindings
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder operation(org.apache.camel.component.aws.securityhub.SecurityHubOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws.securityhub.SecurityHubOperations</code> type.
         * 
         * Required: true
         * Default: batchImportFindings
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The region in which the Security Hub client needs to work. When using
         * this parameter, the configuration will expect the lowercase name of
         * the region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Security Hub client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Security Hub client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Security Hub client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Security Hub
         * client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Security Hub
         * client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the Security Hub client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Security Hub client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Security Hub client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Security Hub client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Security Hub client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Security Hub.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Security Hub client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Security Hub.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Security Hub component.
     */
    public interface AdvancedSecurityHubEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SecurityHubEndpointBuilder basic() {
            return (SecurityHubEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSecurityHubEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSecurityHubEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing configured AWS Security Hub client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.securityhub.SecurityHubClient</code> type.
         * 
         * Group: advanced
         * 
         * @param securityHubClient the value to set
         * @return the dsl builder
         */
        default AdvancedSecurityHubEndpointBuilder securityHubClient(software.amazon.awssdk.services.securityhub.SecurityHubClient securityHubClient) {
            doSetProperty("securityHubClient", securityHubClient);
            return this;
        }
        /**
         * To use an existing configured AWS Security Hub client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.securityhub.SecurityHubClient</code> type.
         * 
         * Group: advanced
         * 
         * @param securityHubClient the value to set
         * @return the dsl builder
         */
        default AdvancedSecurityHubEndpointBuilder securityHubClient(String securityHubClient) {
            doSetProperty("securityHubClient", securityHubClient);
            return this;
        }
    }

    public interface SecurityHubBuilders {
        /**
         * AWS Security Hub (camel-aws-security-hub)
         * Manage and interact with AWS Security Hub for security findings.
         * 
         * Category: cloud,security
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws-security-hub
         * 
         * @return the dsl builder for the headers' name.
         */
        default SecurityHubHeaderNameBuilder awsSecurityHub() {
            return SecurityHubHeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Security Hub (camel-aws-security-hub)
         * Manage and interact with AWS Security Hub for security findings.
         * 
         * Category: cloud,security
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws-security-hub
         * 
         * Syntax: <code>aws-security-hub:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder awsSecurityHub(String path) {
            return SecurityHubEndpointBuilderFactory.endpointBuilder("aws-security-hub", path);
        }
        /**
         * AWS Security Hub (camel-aws-security-hub)
         * Manage and interact with AWS Security Hub for security findings.
         * 
         * Category: cloud,security
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws-security-hub
         * 
         * Syntax: <code>aws-security-hub:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default SecurityHubEndpointBuilder awsSecurityHub(String componentName, String path) {
            return SecurityHubEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Security Hub component.
     */
    public static class SecurityHubHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SecurityHubHeaderNameBuilder INSTANCE = new SecurityHubHeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubOperation}.
         */
        public String awsSecurityHubOperation() {
            return "CamelAwsSecurityHubOperation";
        }
        /**
         * The list of findings to import.
         * 
         * The option is a: {@code List<AwsSecurityFinding>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubFindings}.
         */
        public String awsSecurityHubFindings() {
            return "CamelAwsSecurityHubFindings";
        }
        /**
         * The finding identifiers for batch update.
         * 
         * The option is a: {@code List<AwsSecurityFindingIdentifier>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsSecurityHubFindingIdentifiers}.
         */
        public String awsSecurityHubFindingIdentifiers() {
            return "CamelAwsSecurityHubFindingIdentifiers";
        }
        /**
         * The filters to apply when retrieving findings.
         * 
         * The option is a: {@code AwsSecurityFindingFilters} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubFilters}.
         */
        public String awsSecurityHubFilters() {
            return "CamelAwsSecurityHubFilters";
        }
        /**
         * The note to add to findings during update.
         * 
         * The option is a: {@code NoteUpdate} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubNote}.
         */
        public String awsSecurityHubNote() {
            return "CamelAwsSecurityHubNote";
        }
        /**
         * The severity to set on findings during update.
         * 
         * The option is a: {@code SeverityUpdate} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubSeverity}.
         */
        public String awsSecurityHubSeverity() {
            return "CamelAwsSecurityHubSeverity";
        }
        /**
         * The workflow status to set on findings.
         * 
         * The option is a: {@code WorkflowUpdate} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubWorkflow}.
         */
        public String awsSecurityHubWorkflow() {
            return "CamelAwsSecurityHubWorkflow";
        }
        /**
         * The verification state to set on findings.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsSecurityHubVerificationState}.
         */
        public String awsSecurityHubVerificationState() {
            return "CamelAwsSecurityHubVerificationState";
        }
        /**
         * The confidence level to set on findings.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubConfidence}.
         */
        public String awsSecurityHubConfidence() {
            return "CamelAwsSecurityHubConfidence";
        }
        /**
         * The criticality level to set on findings.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubCriticality}.
         */
        public String awsSecurityHubCriticality() {
            return "CamelAwsSecurityHubCriticality";
        }
        /**
         * User-defined fields to add to findings.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsSecurityHubUserDefinedFields}.
         */
        public String awsSecurityHubUserDefinedFields() {
            return "CamelAwsSecurityHubUserDefinedFields";
        }
        /**
         * Related findings to associate.
         * 
         * The option is a: {@code List<RelatedFinding>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubRelatedFindings}.
         */
        public String awsSecurityHubRelatedFindings() {
            return "CamelAwsSecurityHubRelatedFindings";
        }
        /**
         * The types to assign to findings.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSecurityHubTypes}.
         */
        public String awsSecurityHubTypes() {
            return "CamelAwsSecurityHubTypes";
        }
        /**
         * The token for the next set of results.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: getFindings listEnabledProductsForImport getFindingHistory
         * 
         * @return the name of the header {@code AwsSecurityHubNextToken}.
         */
        public String awsSecurityHubNextToken() {
            return "CamelAwsSecurityHubNextToken";
        }
        /**
         * The maximum number of results to return.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: getFindings
         * 
         * @return the name of the header {@code AwsSecurityHubMaxResults}.
         */
        public String awsSecurityHubMaxResults() {
            return "CamelAwsSecurityHubMaxResults";
        }
        /**
         * The count of findings that failed to import.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: batchImportFindings
         * 
         * @return the name of the header {@code AwsSecurityHubFailedCount}.
         */
        public String awsSecurityHubFailedCount() {
            return "CamelAwsSecurityHubFailedCount";
        }
        /**
         * The count of findings that were successfully imported.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: batchImportFindings
         * 
         * @return the name of the header {@code AwsSecurityHubSuccessCount}.
         */
        public String awsSecurityHubSuccessCount() {
            return "CamelAwsSecurityHubSuccessCount";
        }
        /**
         * The list of findings that were not updated.
         * 
         * The option is a: {@code List<BatchUpdateFindingsUnprocessedFinding>}
         * type.
         * 
         * Group: batchUpdateFindings
         * 
         * @return the name of the header {@code
         * AwsSecurityHubUnprocessedFindings}.
         */
        public String awsSecurityHubUnprocessedFindings() {
            return "CamelAwsSecurityHubUnprocessedFindings";
        }
        /**
         * The list of findings that were updated successfully.
         * 
         * The option is a: {@code List<AwsSecurityFindingIdentifier>} type.
         * 
         * Group: batchUpdateFindings
         * 
         * @return the name of the header {@code
         * AwsSecurityHubProcessedFindings}.
         */
        public String awsSecurityHubProcessedFindings() {
            return "CamelAwsSecurityHubProcessedFindings";
        }
        /**
         * The finding ID to get history for.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: getFindingHistory
         * 
         * @return the name of the header {@code AwsSecurityHubFindingId}.
         */
        public String awsSecurityHubFindingId() {
            return "CamelAwsSecurityHubFindingId";
        }
        /**
         * The product ARN for the finding.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: getFindingHistory
         * 
         * @return the name of the header {@code AwsSecurityHubProductArn}.
         */
        public String awsSecurityHubProductArn() {
            return "CamelAwsSecurityHubProductArn";
        }
    }
    static SecurityHubEndpointBuilder endpointBuilder(String componentName, String path) {
        class SecurityHubEndpointBuilderImpl extends AbstractEndpointBuilder implements SecurityHubEndpointBuilder, AdvancedSecurityHubEndpointBuilder {
            public SecurityHubEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SecurityHubEndpointBuilderImpl(path);
    }
}