/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.CryptoException;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.io.Utils;

public class SignerOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private Signer sig;

    public SignerOutputStream(String string, Signer signer) {
        this.algorithmName = string;
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.sig = signer;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update((byte)n);
    }

    byte[] getSignature() throws CryptoException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.sig.generateSignature();
    }

    boolean verify(byte[] byArray) throws InvalidSignatureException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.sig.verifySignature(byArray);
    }
}

