/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.test.AuthTest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AuthSHA2Test
extends AuthTest {
    @BeforeAll
    public static void setup() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        System.setProperty("zookeeper.DigestAuthenticationProvider.digestAlg", AuthTest.DigestAlgEnum.SHA_256.getName());
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:wjySwxg860UATFtciuZ1lpzrCHrPeov6SPu/ZD56uig=");
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.test.InvalidAuthProvider");
    }

    @AfterAll
    public static void teardown() {
        Security.removeProvider("BC");
        System.clearProperty("zookeeper.DigestAuthenticationProvider.superDigest");
        System.clearProperty("zookeeper.DigestAuthenticationProvider.digestAlg");
    }

    @Override
    @Test
    public void testBadAuthNotifiesWatch() throws Exception {
        super.testBadAuthNotifiesWatch();
    }

    @Override
    @Test
    public void testBadAuthThenSendOtherCommands() throws Exception {
        super.testBadAuthThenSendOtherCommands();
    }

    @Override
    @Test
    public void testSuper() throws Exception {
        super.testSuper();
    }

    @Override
    @Test
    public void testSuperACL() throws Exception {
        super.testSuperACL();
    }

    @Override
    @Test
    public void testOrdinaryACL() throws Exception {
        super.testOrdinaryACL();
    }

    @Override
    @Test
    public void testGenerateDigest() throws NoSuchAlgorithmException {
        Assertions.assertEquals((Object)"super:wjySwxg860UATFtciuZ1lpzrCHrPeov6SPu/ZD56uig=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:test"));
        Assertions.assertEquals((Object)"super:Ie58Fw6KA4ucTEDj23imIltKrXNDxQg8Rwtu0biQFcU=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:zookeeper"));
        Assertions.assertEquals((Object)"super:rVOiTPnqEqlpIRXqSoE6+7h6SzbHUrfAe34i8n/gmRU=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:foo"));
        Assertions.assertEquals((Object)"super:vs70GBagNcqIhGR4R6rXP8E3lvJPYhzMpAMx8ghbTUk=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:bar"));
    }

    @Override
    @Test
    public void testDigest() throws NoSuchAlgorithmException {
        Assertions.assertEquals((Object)"9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08", (Object)AuthSHA2Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"test")));
        Assertions.assertEquals((Object)"456831beef3fc1500939995d7369695f48642664a02d5eab9d807592a08b2384", (Object)AuthSHA2Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"zookeeper")));
        Assertions.assertEquals((Object)"2c26b46b68ffc68ff99b453c1d30413413422d706483bfa0f98a5e886266e7ae", (Object)AuthSHA2Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"foo")));
        Assertions.assertEquals((Object)"fcde2b2edba56bf408601fb721fe9b5c338d10ee429ea04fae5511b68fbf8fb9", (Object)AuthSHA2Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"bar")));
    }
}

