/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.Backoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListenableFutureRpcProcessor<RequestT, ResponseT, ResultT>
implements BiConsumer<StorageServerChannel, Throwable>,
FutureCallback<ResponseT>,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(ListenableFutureRpcProcessor.class);
    private final StorageContainerChannel scChannel;
    private final Iterator<Long> backoffs;
    private final ScheduledExecutorService executor;
    private final CompletableFuture<ResultT> resultFuture;
    private CompletableFuture<StorageServerChannel> serverChannelFuture = null;

    protected ListenableFutureRpcProcessor(StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        this.scChannel = channel;
        this.backoffs = backoffPolicy.toBackoffs().iterator();
        this.resultFuture = FutureUtils.createFuture();
        this.executor = executor;
    }

    protected abstract RequestT createRequest();

    protected abstract ListenableFuture<ResponseT> sendRPC(StorageServerChannel var1, RequestT var2);

    protected abstract ResultT processResponse(ResponseT var1) throws Exception;

    public CompletableFuture<ResultT> process() {
        this.serverChannelFuture = this.scChannel.getStorageContainerChannelFuture();
        this.serverChannelFuture.whenCompleteAsync((BiConsumer)this, (Executor)this.executor);
        return this.resultFuture;
    }

    @Override
    public void run() {
        this.process();
    }

    @Override
    public void accept(StorageServerChannel storageServerChannel, Throwable cause) {
        if (null != cause) {
            this.resultFuture.completeExceptionally(cause);
            return;
        }
        this.sendRpcToServerChannel(storageServerChannel);
    }

    private void sendRpcToServerChannel(StorageServerChannel rsChannel) {
        RequestT request;
        try {
            request = this.createRequest();
        }
        catch (Exception e) {
            this.resultFuture.completeExceptionally(e);
            return;
        }
        Futures.addCallback(this.sendRPC(rsChannel, request), (FutureCallback)this, (Executor)this.executor);
    }

    public void onSuccess(ResponseT result) {
        try {
            this.resultFuture.complete(this.processResponse(result));
        }
        catch (Exception e) {
            this.resultFuture.completeExceptionally(e);
        }
    }

    public void onFailure(Throwable t) {
        Status status = null;
        if (t instanceof StatusRuntimeException) {
            status = ((StatusRuntimeException)t).getStatus();
        } else if (t instanceof StatusException) {
            status = ((StatusException)t).getStatus();
        }
        if (Status.NOT_FOUND == status) {
            this.scChannel.resetStorageServerChannelFuture(this.serverChannelFuture);
        }
        if (this.shouldRetryOn(status) && this.backoffs.hasNext()) {
            long backoffMs = this.backoffs.next();
            this.executor.schedule(this, backoffMs, TimeUnit.MILLISECONDS);
        } else {
            this.resultFuture.completeExceptionally(t);
        }
    }

    protected boolean shouldRetryOn(Status statusCode) {
        return Status.NOT_FOUND == statusCode;
    }
}

