/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKSyncLogReader;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class TestNonBlockingReadsMultiReader
extends TestDistributedLogBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMultiReaders() throws Exception {
        String name = "distrlog-multireaders";
        final RateLimiter limiter = RateLimiter.create((double)1000.0);
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        BKDistributedLogManager dlmwrite = this.createNewDLM(confLocal, name);
        final AsyncLogWriter writer = dlmwrite.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(0L)));
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
        final AtomicInteger writeCount = new AtomicInteger(2);
        BKDistributedLogManager dlmread = this.createNewDLM(conf, name);
        BKSyncLogReader reader0 = (BKSyncLogReader)dlmread.getInputStream(0L);
        try {
            ReaderThread[] readerThreads = new ReaderThread[]{new ReaderThread("reader0-non-blocking", (LogReader)reader0, false)};
            final AtomicBoolean running = new AtomicBoolean(true);
            Thread writerThread = new Thread("WriteThread"){

                @Override
                public void run() {
                    try {
                        long txid = 2L;
                        DLSN dlsn = DLSN.InvalidDLSN;
                        while (running.get()) {
                            long curTxId;
                            limiter.acquire();
                            ++txid;
                            dlsn = (DLSN)Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(curTxId)));
                            writeCount.incrementAndGet();
                            if (curTxId % 1000L != 0L) continue;
                            TestDistributedLogBase.LOG.info("writer write {}", (Object)curTxId);
                        }
                        TestDistributedLogBase.LOG.info("Completed writing record at {}", (Object)dlsn);
                        Utils.close((AsyncCloseable)writer);
                    }
                    catch (DLInterruptedException die) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            for (ReaderThread rt : readerThreads) {
                rt.start();
            }
            writerThread.start();
            TimeUnit.SECONDS.sleep(5L);
            LOG.info("Stopping writer");
            running.set(false);
            writerThread.join();
            LOG.info("Writer stopped after writing {} records, waiting for reader to complete", (Object)writeCount.get());
            while (writeCount.get() > readerThreads[0].getReadCount()) {
                LOG.info("Write Count = {}, Read Count = {}", new Object[]{writeCount.get(), readerThreads[0].getReadCount()});
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            Assert.assertEquals((long)writeCount.get(), (long)readerThreads[0].getReadCount());
            for (ReaderThread readerThread : readerThreads) {
                readerThread.stopReading();
            }
        }
        finally {
            dlmwrite.close();
            reader0.close();
            dlmread.close();
        }
    }

    static class ReaderThread
    extends Thread {
        final LogReader reader;
        final boolean nonBlockReading;
        volatile boolean running = true;
        final AtomicInteger readCount = new AtomicInteger(0);

        ReaderThread(String name, LogReader reader, boolean nonBlockReading) {
            super(name);
            this.reader = reader;
            this.nonBlockReading = nonBlockReading;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    LogRecordWithDLSN r = this.reader.readNext(this.nonBlockReading);
                    if (r == null) continue;
                    this.readCount.incrementAndGet();
                    if (this.readCount.get() % 1000 != 0) continue;
                    TestDistributedLogBase.LOG.info("{} reading {}", (Object)this.getName(), (Object)r.getTransactionId());
                }
                catch (DLInterruptedException die) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    break;
                }
            }
        }

        void stopReading() {
            TestDistributedLogBase.LOG.info("Stopping reader.");
            this.running = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                TestDistributedLogBase.LOG.error("Interrupted on waiting reader thread {} exiting : ", (Object)this.getName(), (Object)e);
            }
        }

        int getReadCount() {
            return this.readCount.get();
        }
    }
}

