/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;

public final class TraceBasedExemplarFilter
implements ExemplarFilterInternal {
    private static final ExemplarFilterInternal INSTANCE = new TraceBasedExemplarFilter();

    private TraceBasedExemplarFilter() {
    }

    public static ExemplarFilterInternal getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean shouldSampleMeasurement(long value, Attributes attributes, Context context) {
        return TraceBasedExemplarFilter.hasSampledTrace(context);
    }

    @Override
    public boolean shouldSampleMeasurement(double value, Attributes attributes, Context context) {
        return TraceBasedExemplarFilter.hasSampledTrace(context);
    }

    private static boolean hasSampledTrace(Context context) {
        return Span.fromContext((Context)context).getSpanContext().isSampled();
    }

    public String toString() {
        return "TraceBasedExemplarFilter";
    }
}

