/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.curator.shaded.com.google.common.base.Preconditions;

public class InterProcessSemaphoreMutex
implements InterProcessLock {
    private final InterProcessSemaphoreV2 semaphore;
    private final WatcherRemoveCuratorFramework watcherRemoveClient;
    private volatile Lease lease;

    public InterProcessSemaphoreMutex(CuratorFramework client, String path) {
        this.watcherRemoveClient = client.newWatcherRemoveCuratorFramework();
        this.semaphore = new InterProcessSemaphoreV2((CuratorFramework)this.watcherRemoveClient, path, 1);
    }

    @Override
    public void acquire() throws Exception {
        this.lease = this.semaphore.acquire();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        return true;
    }

    @Override
    public void release() throws Exception {
        Lease lease = this.lease;
        Preconditions.checkState((lease != null ? 1 : 0) != 0, (Object)"Not acquired");
        this.lease = null;
        lease.close();
        this.watcherRemoveClient.removeWatchers();
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

