/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.cli.DelQuotaCommand;
import org.apache.zookeeper.cli.ListQuotaCommand;
import org.apache.zookeeper.cli.MalformedPathException;
import org.apache.zookeeper.cli.SetQuotaCommand;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.StatsTrackTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZooKeeperQuotaTest
extends ClientBase {
    private ZooKeeper zk = null;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zookeeper.enforceQuota", "true");
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.enforceQuota");
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testQuota() throws Exception {
        String path = "/a/b/v";
        this.zk.setData("/", "some".getBytes(), -1);
        this.zk.create("/a", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/a/b", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/a/b/v", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/a/b/v/d", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack quota = new StatsTrack();
        quota.setCount(4L);
        quota.setCountHardLimit(4L);
        quota.setBytes(9L);
        quota.setByteHardLimit(15L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/a/b/v", (StatsTrack)quota);
        String absolutePath = Quotas.limitPath((String)"/a/b/v");
        byte[] data = this.zk.getData(absolutePath, false, new Stat());
        StatsTrack st = new StatsTrack(data);
        Assertions.assertTrue((st.getBytes() == 9L ? 1 : 0) != 0, (String)"bytes are set");
        Assertions.assertTrue((st.getByteHardLimit() == 15L ? 1 : 0) != 0, (String)"byte hard limit is set");
        Assertions.assertTrue((st.getCount() == 4L ? 1 : 0) != 0, (String)"num count is set");
        Assertions.assertTrue((st.getCountHardLimit() == 4L ? 1 : 0) != 0, (String)"count hard limit is set");
        StatsTrackTest.OldStatsTrack ost = new StatsTrackTest.OldStatsTrack(new String(data));
        Assertions.assertTrue((ost.getBytes() == 9L ? 1 : 0) != 0, (String)"bytes are set");
        Assertions.assertTrue((ost.getCount() == 4 ? 1 : 0) != 0, (String)"num count is set");
        String statPath = Quotas.statPath((String)"/a/b/v");
        byte[] qdata = this.zk.getData(statPath, false, new Stat());
        StatsTrack qst = new StatsTrack(qdata);
        Assertions.assertTrue((qst.getBytes() == 8L ? 1 : 0) != 0, (String)"bytes are set");
        Assertions.assertTrue((qst.getCount() == 2L ? 1 : 0) != 0, (String)"count is set");
        this.stopServer();
        this.startServer();
        this.stopServer();
        this.startServer();
        ZooKeeperServer server = this.serverFactory.getZooKeeperServer();
        Assertions.assertNotNull((Object)(server.getZKDatabase().getDataTree().getMaxPrefixWithQuota("/a/b/v") != null ? 1 : 0), (String)"Quota is still set");
    }

    @Test
    public void testSetQuota() throws IOException, InterruptedException, KeeperException, MalformedPathException {
        String path = "/c1";
        String nodeData = "foo";
        this.zk.create(path, nodeData.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 10;
        long bytes = 5L;
        StatsTrack quota = new StatsTrack();
        quota.setCount((long)count);
        quota.setBytes(bytes);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)quota);
        String absoluteLimitPath = Quotas.limitPath((String)path);
        byte[] data = this.zk.getData(absoluteLimitPath, false, null);
        StatsTrack st = new StatsTrack(data);
        Assertions.assertEquals((long)bytes, (long)st.getBytes());
        Assertions.assertEquals((long)count, (long)st.getCount());
        String absoluteStatPath = Quotas.statPath((String)path);
        data = this.zk.getData(absoluteStatPath, false, null);
        st = new StatsTrack(data);
        Assertions.assertEquals((long)nodeData.length(), (long)st.getBytes());
        Assertions.assertEquals((long)1L, (long)st.getCount());
        String path2 = "/c1/c2";
        String nodeData2 = "bar";
        this.zk.create(path2, nodeData2.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        absoluteStatPath = Quotas.statPath((String)path);
        data = this.zk.getData(absoluteStatPath, false, null);
        st = new StatsTrack(data);
        Assertions.assertEquals((long)(nodeData.length() + nodeData2.length()), (long)st.getBytes());
        Assertions.assertEquals((long)2L, (long)st.getCount());
    }

    @Test
    public void testSetQuotaWhenSetQuotaOnParentOrChildPath() throws IOException, InterruptedException, KeeperException, MalformedPathException {
        this.zk.create("/c1", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/c1/c2", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/c1/c2/c3", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/c1/c2/c3/c4", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/c1/c2/c3/c4/c5", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack quota = new StatsTrack();
        quota.setCount(5L);
        quota.setBytes(10L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/c1/c2/c3", (StatsTrack)quota);
        try {
            SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/c1", (StatsTrack)quota);
            Assertions.fail((String)"should not set quota when child has a quota");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"/c1 has a child /c1/c2/c3 which has a quota", (Object)e.getMessage());
        }
        try {
            SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/c1/c2/c3/c4/c5", (StatsTrack)quota);
            Assertions.fail((String)"should not set quota when parent has a quota");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"/c1/c2/c3/c4/c5 has a parent /c1/c2/c3 which has a quota", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetQuotaWhenExceedBytesSoftQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack st = new StatsTrack();
        st.setBytes(5L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.setData(path, "12345".getBytes(), -1);
        try {
            this.zk.setData(path, "123456".getBytes(), -1);
            ZooKeeperQuotaTest.validateNoQuotaExceededMetrics(namespace);
        }
        catch (Exception e) {
            Assertions.fail((String)"should set data which exceeds the soft byte quota");
        }
    }

    @Test
    public void testSetQuotaWhenExceedBytesHardQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "12345".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit(5L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        try {
            this.zk.setData(path, "123456".getBytes(), -1);
            Assertions.fail((String)"should not set data which exceeds the hard byte quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testSetQuotaWhenExceedBytesHardQuotaExtend() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int bytes = 100;
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit((long)bytes);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        StringBuilder sb = new StringBuilder(path);
        for (int i = 1; i <= bytes; ++i) {
            sb.append("/c" + i);
            if (i == bytes) {
                try {
                    this.zk.create(sb.toString(), "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    Assertions.fail((String)"should not set quota when exceeds hard bytes quota");
                }
                catch (KeeperException.QuotaExceededException e) {
                    this.validateQuotaExceededMetrics(namespace);
                }
                continue;
            }
            this.zk.create(sb.toString(), "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    @Test
    public void testSetQuotaWhenSetQuotaLessThanExistBytes() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "123456789".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int bytes = 5;
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit((long)bytes);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        try {
            this.zk.setData(path, "123456".getBytes(), -1);
            Assertions.fail((String)"should not set quota when exceeds hard bytes quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testSetQuotaWhenSetChildDataExceedBytesQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace + "/quota";
        this.zk.create("/" + namespace, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create(path, "01234".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create(path + "/data", "56789".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack quota = new StatsTrack();
        quota.setByteHardLimit(10L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)quota);
        try {
            this.zk.setData(path + "/data", "567891".getBytes(), -1);
            Assertions.fail((String)"should not set data when exceed hard byte quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testSetQuotaWhenCreateNodeExceedBytesQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace + "/quota";
        this.zk.create("/" + namespace, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create(path, "01234".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack quota = new StatsTrack();
        quota.setByteHardLimit(10L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)quota);
        try {
            this.zk.create(path + "/data", "567891".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"should not set data when exceed hard byte quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testSetQuotaWhenExceedCountSoftQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 2;
        StatsTrack st = new StatsTrack();
        st.setCount((long)count);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.create(path + "/c2", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.zk.create(path + "/c2/c3", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ZooKeeperQuotaTest.validateNoQuotaExceededMetrics(namespace);
        }
        catch (KeeperException.QuotaExceededException e) {
            Assertions.fail((String)"should set quota when exceeds soft count quota");
        }
    }

    @Test
    public void testSetQuotaWhenExceedCountHardQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 2;
        StatsTrack st = new StatsTrack();
        st.setCountHardLimit((long)count);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.create(path + "/c2", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.zk.create(path + "/c2/c3", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"should not set quota when exceeds hard count quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testSetQuotaWhenExceedCountHardQuotaExtend() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 100;
        StatsTrack st = new StatsTrack();
        st.setCountHardLimit((long)count);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        StringBuilder sb = new StringBuilder(path);
        for (int i = 1; i <= count; ++i) {
            sb.append("/c" + i);
            if (i == count) {
                try {
                    this.zk.create(sb.toString(), "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    Assertions.fail((String)"should not set quota when exceeds hard count quota");
                }
                catch (KeeperException.QuotaExceededException e) {
                    this.validateQuotaExceededMetrics(namespace);
                }
                continue;
            }
            this.zk.create(sb.toString(), "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    @Test
    public void testSetQuotaWhenSetQuotaLessThanExistCount() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create(path + "/c1", "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create(path + "/c2", "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 2;
        StatsTrack st = new StatsTrack();
        st.setCountHardLimit((long)count);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        try {
            this.zk.create(path + "/c3", "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"should not set quota when exceeds hard count quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testSetQuotaWhenExceedBothBytesAndCountHardQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "12345".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit(5L);
        st.setCountHardLimit(1L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        try {
            this.zk.create(path + "/c2", "1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"should give priority to CountQuotaExceededException when both meets the count and bytes quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
    }

    @Test
    public void testMultiCreateThenSetDataShouldWork() throws Exception {
        String path = "/a";
        String subPath = "/a/b";
        this.zk.create("/a", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] data13b = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit((long)data13b.length);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/a", (StatsTrack)st);
        List<Op> ops = Arrays.asList(Op.create((String)"/a/b", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/a/b", (byte[])data13b, (int)-1));
        this.zk.multi(ops);
    }

    @Test
    public void testMultiCreateThenSetDataShouldFail() throws Exception {
        String path = "/a";
        String subPath = "/a/b";
        this.zk.create("/a", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] data13b = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit((long)(data13b.length - 1));
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/a", (StatsTrack)st);
        List<Op> ops = Arrays.asList(Op.create((String)"/a/b", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/a/b", (byte[])data13b, (int)-1));
        try {
            this.zk.multi(ops);
            Assertions.fail((String)"should fail transaction when hard quota is exceeded");
        }
        catch (KeeperException.QuotaExceededException quotaExceededException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.zk.exists("/a/b", null));
    }

    @Test
    public void testDeleteBytesQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "12345".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit(5L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        try {
            this.zk.setData(path, "123456".getBytes(), -1);
            Assertions.fail((String)"should not set data which exceeds the hard byte quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
        st = new StatsTrack();
        st.setByteHardLimit(1L);
        DelQuotaCommand.delQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.setData(path, "123456".getBytes(), -1);
        this.validateQuotaExceededMetrics(namespace);
    }

    @Test
    public void testDeleteCountQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 2;
        StatsTrack st = new StatsTrack();
        st.setCountHardLimit((long)count);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.create(path + "/c2", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.zk.create(path + "/c2/c3", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"should not set quota when exceeds hard count quota");
        }
        catch (KeeperException.QuotaExceededException e) {
            this.validateQuotaExceededMetrics(namespace);
        }
        st = new StatsTrack();
        st.setCountHardLimit(1L);
        DelQuotaCommand.delQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.create(path + "/c2/c3", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.validateQuotaExceededMetrics(namespace);
    }

    @Test
    public void testListQuota() throws Exception {
        int i;
        String path = "/c1";
        this.zk.create("/c1", "12345".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack st = new StatsTrack();
        long bytes = 5L;
        int count = 10;
        long byteHardLimit = 6L;
        int countHardLimit = 12;
        st.setBytes(bytes);
        st.setCount((long)count);
        st.setByteHardLimit(byteHardLimit);
        st.setCountHardLimit((long)countHardLimit);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)"/c1", (StatsTrack)st);
        List statsTracks = ListQuotaCommand.listQuota((ZooKeeper)this.zk, (String)"/c1");
        for (i = 0; i < statsTracks.size(); ++i) {
            st = (StatsTrack)statsTracks.get(i);
            if (i == 0) {
                Assertions.assertEquals((long)count, (long)st.getCount());
                Assertions.assertEquals((long)countHardLimit, (long)st.getCountHardLimit());
                Assertions.assertEquals((long)bytes, (long)st.getBytes());
                Assertions.assertEquals((long)byteHardLimit, (long)st.getByteHardLimit());
                continue;
            }
            Assertions.assertEquals((long)1L, (long)st.getCount());
            Assertions.assertEquals((long)-1L, (long)st.getCountHardLimit());
            Assertions.assertEquals((long)5L, (long)st.getBytes());
            Assertions.assertEquals((long)-1L, (long)st.getByteHardLimit());
        }
        st = new StatsTrack();
        st.setByteHardLimit(1L);
        st.setBytes(1L);
        st.setCountHardLimit(1L);
        st.setCount(1L);
        DelQuotaCommand.delQuota((ZooKeeper)this.zk, (String)"/c1", (StatsTrack)st);
        statsTracks = ListQuotaCommand.listQuota((ZooKeeper)this.zk, (String)"/c1");
        for (i = 0; i < statsTracks.size(); ++i) {
            st = (StatsTrack)statsTracks.get(i);
            if (i == 0) {
                Assertions.assertEquals((long)-1L, (long)st.getCount());
                Assertions.assertEquals((long)-1L, (long)st.getCountHardLimit());
                Assertions.assertEquals((long)-1L, (long)st.getBytes());
                Assertions.assertEquals((long)-1L, (long)st.getByteHardLimit());
                continue;
            }
            Assertions.assertEquals((long)1L, (long)st.getCount());
            Assertions.assertEquals((long)-1L, (long)st.getCountHardLimit());
            Assertions.assertEquals((long)5L, (long)st.getBytes());
            Assertions.assertEquals((long)-1L, (long)st.getByteHardLimit());
        }
    }

    private void validateQuotaExceededMetrics(String namespace) {
        String name = "quota_exceeded_error_per_namespace";
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(key -> key.contains(String.format("%s_%s", namespace, "quota_exceeded_error_per_namespace"))).count());
        Assertions.assertEquals((Object)1L, (Object)metrics.get(String.format("%s_%s", namespace, "quota_exceeded_error_per_namespace")));
    }

    static void validateNoQuotaExceededMetrics(String namespace) {
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)0L, (long)metrics.keySet().stream().filter(key -> key.contains(String.format("%s_%s", namespace, "quota_exceeded_error_per_namespace"))).count());
    }
}

