/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.general.CamelliaEngine;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.Poly1305Impl;
import org.bouncycastle.crypto.general.Poly1305KeyGenerator;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SEEDEngine;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.SerpentEngine;
import org.bouncycastle.crypto.general.TwofishEngine;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class Poly1305 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("Poly1305");
    private static final EngineProvider ENGINE_PROVIDER;
    private static final EngineProvider AES_ENGINE_PROVIDER;
    private static final EngineProvider CAMILLIA_ENGINE_PROVIDER;
    private static final EngineProvider SEED_ENGINE_PROVIDER;
    private static final EngineProvider SERPENT_ENGINE_PROVIDER;
    private static final EngineProvider TWOFISH_ENGINE_PROVIDER;
    public static final AuthParameters MAC;
    public static final AuthParameters MACwithAES;
    public static final AuthParameters MACwithCAMELLIA;
    public static final AuthParameters MACwithSEED;
    public static final AuthParameters MACwithSerpent;
    public static final AuthParameters MACwithTwofish;

    private Poly1305() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (Poly1305.invalidKeySize(n)) {
            throw new IllegalKeyException("Poly1305 key must be 256 bits");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n) {
        return n != 256;
    }

    static {
        Poly1305EngineProvider poly1305EngineProvider = new Poly1305EngineProvider();
        poly1305EngineProvider.createEngine();
        ENGINE_PROVIDER = poly1305EngineProvider;
        AES_ENGINE_PROVIDER = new Poly1305WithCipherEngineProvider((BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine(), Hex.decode("7be23689db44d57e92ebc8a8a3889cec"));
        CAMILLIA_ENGINE_PROVIDER = new Poly1305WithCipherEngineProvider(new CamelliaEngine(), Hex.decode("05dfbf3c18010cc02d1eec23798b62f7"));
        SEED_ENGINE_PROVIDER = new Poly1305WithCipherEngineProvider(new SEEDEngine(), Hex.decode("b916a6635980a54822304a84cf8e5cfd"));
        SERPENT_ENGINE_PROVIDER = new Poly1305WithCipherEngineProvider(new SerpentEngine(), Hex.decode("f7c50b5c4eed1fbb6595fa04a36b33a0"));
        TWOFISH_ENGINE_PROVIDER = new Poly1305WithCipherEngineProvider(new TwofishEngine(), Hex.decode("63c7226bf5344b102fd1906d7b20dc1c"));
        MAC = new AuthParameters(ALGORITHM);
        MACwithAES = new AuthParameters(ALGORITHM, AES_ENGINE_PROVIDER);
        MACwithCAMELLIA = new AuthParameters(ALGORITHM, CAMILLIA_ENGINE_PROVIDER);
        MACwithSEED = new AuthParameters(ALGORITHM, SEED_ENGINE_PROVIDER);
        MACwithSerpent = new AuthParameters(ALGORITHM, SERPENT_ENGINE_PROVIDER);
        MACwithTwofish = new AuthParameters(ALGORITHM, TWOFISH_ENGINE_PROVIDER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private final boolean ivRequired;
        private final EngineProvider engineProvider;

        private AuthParameters(GeneralAlgorithm generalAlgorithm, boolean bl, byte[] byArray, int n, EngineProvider engineProvider) {
            super(generalAlgorithm, 16, byArray, n);
            this.ivRequired = bl;
            this.engineProvider = engineProvider;
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, false, null, 128, ENGINE_PROVIDER);
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm, EngineProvider engineProvider) {
            this(generalAlgorithm, true, null, 128, engineProvider);
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            return new AuthParameters(generalAlgorithm, this.ivRequired, byArray, n, this.engineProvider);
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private static final int keySizeInBits = 256;
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this(ALGORITHM, secureRandom);
        }

        public KeyGenerator(GeneralParameters generalParameters, SecureRandom secureRandom) {
            this((GeneralAlgorithm)generalParameters.getAlgorithm(), secureRandom);
        }

        private KeyGenerator(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            Poly1305KeyGenerator poly1305KeyGenerator = new Poly1305KeyGenerator();
            ((CipherKeyGenerator)poly1305KeyGenerator).init(new KeyGenerationParameters(this.random, 256));
            return new SymmetricSecretKey(this.algorithm, ((CipherKeyGenerator)poly1305KeyGenerator).generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = (Mac)authParameters.engineProvider.createEngine();
            if (authParameters.ivRequired) {
                if (authParameters.iv == null) {
                    throw new IllegalArgumentException("Poly1305 requires a 128 bit IV when used with a block cipher");
                }
                mac.init(new ParametersWithIV(new KeyParameterImpl(Poly1305.validateKey(symmetricKey, authParameters.getAlgorithm()).getKeyBytes()), authParameters.iv));
            } else {
                mac.init(new KeyParameterImpl(Poly1305.validateKey(symmetricKey, authParameters.getAlgorithm()).getKeyBytes()));
            }
            return mac;
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Poly1305EngineProvider
    implements EngineProvider<Mac> {
        static final byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
        static final byte[] output = Hex.decode("ef9e732a7f2df185a71180ae583a0f93");
        static final byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");

        private Poly1305EngineProvider() {
        }

        @Override
        public Mac createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new Poly1305Impl(), new VariantKatTest<Poly1305Impl>(){

                @Override
                public void evaluate(Poly1305Impl poly1305Impl) {
                    byte[] byArray = new byte[poly1305Impl.getMacSize()];
                    poly1305Impl.init(new KeyParameterImpl(key));
                    poly1305Impl.update(input, 0, input.length);
                    poly1305Impl.doFinal(byArray, 0);
                    if (!Arrays.areEqual(output, byArray)) {
                        this.fail("Failed self test on encryption");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Poly1305WithCipherEngineProvider
    implements EngineProvider<Mac> {
        private static final byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
        private static final byte[] iv = Hex.decode("000102030405060708090a0b0c0d0e0f");
        private static final byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        private final byte[] output;
        private final BlockCipher engine;

        public Poly1305WithCipherEngineProvider(BlockCipher blockCipher, byte[] byArray) {
            this.engine = blockCipher;
            this.output = byArray;
        }

        @Override
        public Mac createEngine() {
            Poly1305Impl poly1305Impl = new Poly1305Impl(this.engine);
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, poly1305Impl, new VariantKatTest<Poly1305Impl>(){

                @Override
                public void evaluate(Poly1305Impl poly1305Impl) {
                    byte[] byArray = new byte[poly1305Impl.getMacSize()];
                    poly1305Impl.init(new ParametersWithIV(new KeyParameterImpl(key), iv));
                    poly1305Impl.update(input, 0, input.length);
                    poly1305Impl.doFinal(byArray, 0);
                    if (!Arrays.areEqual(Poly1305WithCipherEngineProvider.this.output, byArray)) {
                        this.fail("Failed self test on encryption");
                    }
                }
            });
        }
    }
}

