/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.server.MockServerCnxn;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ZooKeeperServerTest
extends ZKTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirSize() throws Exception {
        ZooKeeperServer zks = null;
        ServerCnxnFactory cnxnFactory = null;
        try {
            File dataDir = ClientBase.createTmpDir();
            File logDir = ClientBase.createTmpDir();
            zks = new ZooKeeperServer(dataDir, logDir, 3000);
            Assertions.assertEquals((long)0L, (long)zks.getDataDirSize());
            Assertions.assertEquals((long)0L, (long)zks.getLogDirSize());
            String hostPort = "127.0.0.1:" + PortAssignment.unique();
            int port = Integer.parseInt(hostPort.split(":")[1]);
            cnxnFactory = ServerCnxnFactory.createFactory((int)port, (int)-1);
            cnxnFactory.startup(zks);
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(hostPort, 120000L));
            Assertions.assertTrue((zks.getDataDirSize() > 0L ? 1 : 0) != 0);
            Assertions.assertEquals((long)0L, (long)zks.getLogDirSize());
        }
        finally {
            if (cnxnFactory != null) {
                cnxnFactory.shutdown();
            }
            if (zks != null) {
                zks.shutdown();
            }
        }
    }

    @Test
    public void testSortDataDirAscending() {
        File[] files = new File[]{new File("foo.10027c6de"), new File("foo.10027c6df"), new File("bar.10027c6dd"), new File("foo.10027c6dc"), new File("foo.20027c6dc")};
        File[] orig = (File[])files.clone();
        List filelist = Util.sortDataDir((File[])files, (String)"foo", (boolean)true);
        Assertions.assertEquals((Object)orig[2], filelist.get(0));
        Assertions.assertEquals((Object)orig[3], filelist.get(1));
        Assertions.assertEquals((Object)orig[0], filelist.get(2));
        Assertions.assertEquals((Object)orig[1], filelist.get(3));
        Assertions.assertEquals((Object)orig[4], filelist.get(4));
    }

    @Test
    public void testSortDataDirDescending() {
        File[] files = new File[]{new File("foo.10027c6de"), new File("foo.10027c6df"), new File("bar.10027c6dd"), new File("foo.10027c6dc"), new File("foo.20027c6dc")};
        File[] orig = (File[])files.clone();
        List filelist = Util.sortDataDir((File[])files, (String)"foo", (boolean)false);
        Assertions.assertEquals((Object)orig[4], filelist.get(0));
        Assertions.assertEquals((Object)orig[1], filelist.get(1));
        Assertions.assertEquals((Object)orig[0], filelist.get(2));
        Assertions.assertEquals((Object)orig[3], filelist.get(3));
        Assertions.assertEquals((Object)orig[2], filelist.get(4));
    }

    @Test
    public void testGetLogFiles() {
        File[] files = new File[]{new File("log.10027c6de"), new File("log.10027c6df"), new File("snapshot.10027c6dd"), new File("log.10027c6dc"), new File("log.20027c6dc")};
        File[] orig = (File[])files.clone();
        File[] filelist = FileTxnLog.getLogFiles((File[])files, (long)Long.parseLong("10027c6de", 16));
        Assertions.assertEquals((int)3, (int)filelist.length);
        Assertions.assertEquals((Object)orig[0], (Object)filelist[0]);
        Assertions.assertEquals((Object)orig[1], (Object)filelist[1]);
        Assertions.assertEquals((Object)orig[4], (Object)filelist[2]);
    }

    @Test
    public void testForceSyncDefaultEnabled() {
        File file = new File("foo.10027c6de");
        FileTxnLog log = new FileTxnLog(file);
        Assertions.assertTrue((boolean)log.isForceSync());
    }

    @Test
    public void testForceSyncDefaultDisabled() {
        try {
            File file = new File("foo.10027c6de");
            System.setProperty("zookeeper.forceSync", "no");
            FileTxnLog log = new FileTxnLog(file);
            Assertions.assertFalse((boolean)log.isForceSync());
        }
        finally {
            System.setProperty("zookeeper.forceSync", "yes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSnapshot() {
        File f = null;
        File tmpFileDir = null;
        try {
            tmpFileDir = ClientBase.createTmpDir();
            f = new File(tmpFileDir, "snapshot.0");
            if (!f.exists()) {
                f.createNewFile();
            }
            Assertions.assertFalse((boolean)SnapStream.isValidSnapshot((File)f), (String)"Snapshot file size is greater than 9 bytes");
            Assertions.assertTrue((boolean)f.delete(), (String)"Can't delete file");
        }
        catch (IOException iOException) {
        }
        finally {
            if (null != tmpFileDir) {
                ClientBase.recursiveDelete(tmpFileDir);
            }
        }
    }

    @Test
    public void testClientZxidAhead() {
        ZooKeeperServer zooKeeperServer = new ZooKeeperServer();
        ZKDatabase zkDatabase = new ZKDatabase((FileTxnSnapLog)Mockito.mock(FileTxnSnapLog.class));
        zooKeeperServer.setZKDatabase(zkDatabase);
        ConnectRequest request = new ConnectRequest();
        request.setProtocolVersion(1);
        request.setLastZxidSeen(99L);
        request.setTimeOut(500);
        request.setSessionId(123L);
        request.setPasswd(new byte[]{1});
        request.setReadOnly(true);
        ServerCnxn.CloseRequestException e = (ServerCnxn.CloseRequestException)Assertions.assertThrows(ServerCnxn.CloseRequestException.class, () -> zooKeeperServer.processConnectRequest((ServerCnxn)new MockServerCnxn(), request));
        Assertions.assertEquals((Object)e.getReason(), (Object)ServerCnxn.DisconnectReason.CLIENT_ZXID_AHEAD);
    }

    @Test
    public void testUpdateQuotaExceededMetrics() {
        String name = "quota_exceeded_error_per_namespace";
        String namespace = UUID.randomUUID().toString();
        long count = 3L;
        int i = 0;
        while ((long)i < 3L) {
            ZooKeeperServer.updateQuotaExceededMetrics((String)namespace);
            ++i;
        }
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)1L, (long)values.keySet().stream().filter(key -> key.contains(String.format("%s_%s", namespace, "quota_exceeded_error_per_namespace"))).count());
        Assertions.assertEquals((Object)3L, (Object)values.get(String.format("%s_%s", namespace, "quota_exceeded_error_per_namespace")));
    }

    @Test
    public void testUpdateQuotaExceededMetrics_nullNamespace() {
        Assertions.assertDoesNotThrow(() -> ZooKeeperServer.updateQuotaExceededMetrics(null));
    }
}

