/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metastore;

import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.metastore.InMemoryMetastoreTable;
import org.apache.bookkeeper.metastore.MetaStore;
import org.apache.bookkeeper.metastore.MetastoreException;
import org.apache.bookkeeper.metastore.MetastoreScannableTable;
import org.apache.bookkeeper.metastore.MetastoreTable;
import org.apache.commons.configuration.Configuration;

public class InMemoryMetaStore
implements MetaStore {
    static final int CUR_VERSION = 1;
    static Map<String, InMemoryMetastoreTable> tables = new HashMap<String, InMemoryMetastoreTable>();

    public static void reset() {
        tables.clear();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void init(Configuration conf, int msVersion) throws MetastoreException {
    }

    @Override
    public void close() {
    }

    @Override
    public MetastoreTable createTable(String name) {
        return this.createInMemoryTable(name);
    }

    @Override
    public MetastoreScannableTable createScannableTable(String name) {
        return this.createInMemoryTable(name);
    }

    private InMemoryMetastoreTable createInMemoryTable(String name) {
        InMemoryMetastoreTable t = tables.get(name);
        if (t == null) {
            t = new InMemoryMetastoreTable(this, name);
            tables.put(name, t);
        }
        return t;
    }
}

