/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.table;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.tools.perf.table.KeyGenerator;
import org.apache.bookkeeper.tools.perf.table.PerfClient;

abstract class BenchmarkTask
implements Callable<Void> {
    protected final Table<ByteBuf, ByteBuf> table;
    protected final int tid;
    protected final Random random;
    protected final long numRecords;
    protected final long keyRange;
    protected final PerfClient.Flags flags;
    protected final KeyGenerator generator;

    BenchmarkTask(Table<ByteBuf, ByteBuf> table, int tid, long randSeed, long numRecords, long keyRange, PerfClient.Flags flags, KeyGenerator generator) {
        this.table = table;
        this.tid = tid;
        this.random = new Random(randSeed + (long)(tid * 1000));
        this.numRecords = numRecords;
        this.keyRange = keyRange;
        this.flags = flags;
        this.generator = generator;
    }

    @Override
    public Void call() throws Exception {
        this.runTask();
        return null;
    }

    protected abstract void runTask() throws Exception;

    protected void getFixedKey(ByteBuf key, long sn) {
        this.generator.generateKeyFromLong(key, sn);
    }

    protected void getRandomKey(ByteBuf key, long range) {
        this.generator.generateKeyFromLong(key, Math.abs(this.random.nextLong() % range));
    }

    protected abstract void reportStats(long var1);

    protected abstract void printAggregatedStats();
}

