/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentWatcherTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentWatcherTest.class);
    private BlockingQueue<WatchedEvent> events;
    private Watcher persistentWatcher;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.events = new LinkedBlockingQueue<WatchedEvent>();
        this.persistentWatcher = event -> this.events.add(event);
    }

    @Test
    public void testBasic() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT);
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    @Test
    public void testNullWatch() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> PersistentWatcherTest.lambda$testNullWatch$1((ZooKeeper)zk));
            Assertions.assertThrows(IllegalArgumentException.class, () -> PersistentWatcherTest.lambda$testNullWatch$3((ZooKeeper)zk));
        }
    }

    @Test
    public void testDefaultWatcher() throws IOException, InterruptedException, KeeperException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher(){

            @Override
            public synchronized void process(WatchedEvent event) {
                super.process(event);
                PersistentWatcherTest.this.events.add(event);
            }
        };
        try (TestableZooKeeper zk = this.createClient(watcher, this.hostPort);){
            zk.addWatch("/a/b", AddWatchMode.PERSISTENT);
            this.events.clear();
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    @Test
    public void testBasicAsync() throws IOException, InterruptedException, KeeperException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher(){

            @Override
            public synchronized void process(WatchedEvent event) {
                super.process(event);
                PersistentWatcherTest.this.events.add(event);
            }
        };
        try (TestableZooKeeper zk = this.createClient(watcher, this.hostPort);){
            CountDownLatch latch = new CountDownLatch(1);
            AsyncCallback.VoidCallback cb = (rc, path, ctx) -> {
                if (rc == KeeperException.Code.OK.intValue()) {
                    latch.countDown();
                }
            };
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT, cb, null);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            this.events.clear();
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    @Test
    public void testAsyncDefaultWatcher() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            CountDownLatch latch = new CountDownLatch(1);
            AsyncCallback.VoidCallback cb = (rc, path, ctx) -> {
                if (rc == KeeperException.Code.OK.intValue()) {
                    latch.countDown();
                }
            };
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT, cb, null);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    private void internalTestBasic(ZooKeeper zk) throws KeeperException, InterruptedException {
        zk.create("/a", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/c", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.setData("/a/b", new byte[0], -1);
        zk.delete("/a/b/c", -1);
        zk.delete("/a/b", -1);
        zk.create("/a/b", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b");
        this.assertEvent(this.events, Watcher.Event.EventType.NodeChildrenChanged, "/a/b");
        this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b");
        this.assertEvent(this.events, Watcher.Event.EventType.NodeChildrenChanged, "/a/b");
        this.assertEvent(this.events, Watcher.Event.EventType.NodeDeleted, "/a/b");
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b");
    }

    @Test
    public void testRemoval() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT);
            zk.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.create("/a/b/c", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b");
            this.assertEvent(this.events, Watcher.Event.EventType.NodeChildrenChanged, "/a/b");
            zk.removeWatches("/a/b", this.persistentWatcher, Watcher.WatcherType.Any, false);
            zk.delete("/a/b/c", -1);
            zk.delete("/a/b", -1);
            this.assertEvent(this.events, Watcher.Event.EventType.PersistentWatchRemoved, "/a/b");
        }
    }

    @Test
    public void testDisconnect() throws Exception {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT);
            this.stopServer();
            this.assertEvent(this.events, Watcher.Event.EventType.None, null);
            this.startServer();
            this.assertEvent(this.events, Watcher.Event.EventType.None, null);
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    @Test
    public void testMultiClient() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk1 = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);
             TestableZooKeeper zk2 = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk1.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk1.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk1.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT);
            zk1.setData("/a/b", "one".getBytes(), -1);
            Thread.sleep(1000L);
            zk2.setData("/a/b", "two".getBytes(), -1);
            zk2.setData("/a/b", "three".getBytes(), -1);
            zk2.setData("/a/b", "four".getBytes(), -1);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b");
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b");
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b");
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b");
        }
    }

    @Test
    public void testRootWatcher() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/", this.persistentWatcher, AddWatchMode.PERSISTENT);
            zk.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.setData("/a", new byte[0], -1);
            zk.create("/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeChildrenChanged, "/");
            this.assertEvent(this.events, Watcher.Event.EventType.NodeChildrenChanged, "/");
        }
    }

    private void assertEvent(BlockingQueue<WatchedEvent> events, Watcher.Event.EventType eventType, String path) throws InterruptedException {
        WatchedEvent event = events.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals((Object)eventType, (Object)event.getType());
        Assertions.assertEquals((Object)path, (Object)event.getPath());
    }

    private static /* synthetic */ void lambda$testNullWatch$3(ZooKeeper zk) throws Throwable {
        AsyncCallback.VoidCallback cb = (rc, path, ctx) -> {};
        zk.addWatch("/a/b", null, AddWatchMode.PERSISTENT, cb, null);
    }

    private static /* synthetic */ void lambda$testNullWatch$1(ZooKeeper zk) throws Throwable {
        zk.addWatch("/a/b", null, AddWatchMode.PERSISTENT);
    }
}

