/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.14.0", label="language,core,xml", title="XML Tokenize")
@XmlRootElement(name="xtokenize")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XMLTokenizerExpression
extends NamespaceAwareExpression {
    @XmlAttribute
    @Metadata(defaultValue="i", enums="i,w,u,t")
    private String mode;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String group;

    public XMLTokenizerExpression() {
    }

    protected XMLTokenizerExpression(XMLTokenizerExpression source) {
        super(source);
        this.mode = source.mode;
        this.group = source.group;
    }

    public XMLTokenizerExpression(String expression) {
        super(expression);
    }

    public XMLTokenizerExpression(Expression expression) {
        this.setExpressionValue(expression);
    }

    private XMLTokenizerExpression(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.group = builder.group;
    }

    @Override
    public XMLTokenizerExpression copyDefinition() {
        return new XMLTokenizerExpression(this);
    }

    @Override
    public String getLanguage() {
        return "xtokenize";
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @XmlTransient
    public static class Builder
    extends NamespaceAwareExpression.AbstractNamespaceAwareBuilder<Builder, XMLTokenizerExpression> {
        private String mode;
        private String group;

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode == null ? null : mode.value;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder group(int group) {
            this.group = Integer.toString(group);
            return this;
        }

        @Override
        public XMLTokenizerExpression end() {
            return new XMLTokenizerExpression(this);
        }
    }

    @XmlTransient
    public static enum Mode {
        INJECTING_CONTEXTUAL_NAMESPACE_BINDINGS("i"),
        WRAPPING_EXTRACTED_TOKEN("w"),
        UNWRAPPING_EXTRACTED_TOKEN("u"),
        EXTRACTING_TEXT_CONTENT("t");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }
    }
}

