/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.Arrays;

public class ByteSequence {
    public byte[] data;
    public int offset;
    public int length;

    public ByteSequence() {
    }

    public ByteSequence(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public ByteSequence(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int remaining() {
        return this.length - this.offset;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void compact() {
        if (this.length != this.data.length) {
            byte[] t = new byte[this.length];
            System.arraycopy(this.data, this.offset, t, 0, this.length);
            this.data = t;
            this.offset = 0;
        }
    }

    public void reset() {
        this.length = this.remaining();
        if (this.length > 0) {
            System.arraycopy(this.data, this.offset, this.data, 0, this.length);
        } else {
            this.length = 0;
        }
        this.offset = 0;
    }

    public int indexOf(ByteSequence needle, int pos) {
        int max = this.length - needle.length - this.offset;
        for (int i2 = pos; i2 < max; ++i2) {
            if (!this.matches(needle, i2)) continue;
            return i2;
        }
        return -1;
    }

    private boolean matches(ByteSequence needle, int pos) {
        for (int i2 = 0; i2 < needle.length; ++i2) {
            if (this.data[this.offset + pos + i2] == needle.data[needle.offset + i2]) continue;
            return false;
        }
        return true;
    }

    private byte getByte(int i2) {
        return this.data[this.offset + i2];
    }

    public final int indexOf(byte value, int pos) {
        for (int i2 = pos; i2 < this.length; ++i2) {
            if (this.data[this.offset + i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public boolean startsWith(byte[] bytes) {
        if (this.length - this.offset < bytes.length) {
            return false;
        }
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (this.data[this.offset + i2] == bytes[i2]) continue;
            return false;
        }
        return true;
    }

    public byte[] toArray() {
        return Arrays.copyOfRange(this.getData(), this.getOffset(), this.getLength());
    }
}

